<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\Account;

class ProductCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // البحث عن حساب المبيعات أو إنشاؤه
        $salesAccount = Account::firstOrCreate([
            'name' => 'مبيعات المطعم',
            'type' => 'income',
            'code' => '4001'
        ]);

        // بيانات المنتجات التجريبية مع الفئات
        $products = [
            // فئة الطعام (food)
            [
                'name' => 'برجر لحم',
                'description' => 'برجر لحم طازج مع الخضار والجبن',
                'price' => 25.00,
                'cost' => 15.00,
                'item_type' => 'food',
                'type' => 'product',
                'stock_quantity' => 50,
                'min_stock' => 10,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'برجر دجاج',
                'description' => 'برجر دجاج مشوي مع الصوص الخاص',
                'price' => 22.00,
                'cost' => 12.00,
                'item_type' => 'food',
                'type' => 'product',
                'stock_quantity' => 40,
                'min_stock' => 8,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'بيتزا مارجريتا',
                'description' => 'بيتزا بالجبن والطماطم والريحان',
                'price' => 35.00,
                'cost' => 20.00,
                'item_type' => 'food',
                'type' => 'product',
                'stock_quantity' => 30,
                'min_stock' => 5,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],

            // فئة المقبلات (appetizer)
            [
                'name' => 'أصابع الموزاريلا',
                'description' => 'أصابع الجبن المقلية المقرمشة',
                'price' => 15.00,
                'cost' => 8.00,
                'item_type' => 'appetizer',
                'type' => 'product',
                'stock_quantity' => 25,
                'min_stock' => 5,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'سلطة قيصر',
                'description' => 'سلطة قيصر بالدجاج والجبن',
                'price' => 18.00,
                'cost' => 10.00,
                'item_type' => 'appetizer',
                'type' => 'product',
                'stock_quantity' => 20,
                'min_stock' => 5,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'حلقات البصل',
                'description' => 'حلقات البصل المقلية الذهبية',
                'price' => 12.00,
                'cost' => 6.00,
                'item_type' => 'appetizer',
                'type' => 'product',
                'stock_quantity' => 30,
                'min_stock' => 8,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],

            // فئة المشروبات (beverage)
            [
                'name' => 'كوكا كولا',
                'description' => 'مشروب غازي بارد 330 مل',
                'price' => 5.00,
                'cost' => 2.50,
                'item_type' => 'beverage',
                'type' => 'product',
                'stock_quantity' => 100,
                'min_stock' => 20,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'عصير برتقال طازج',
                'description' => 'عصير برتقال طبيعي 100%',
                'price' => 8.00,
                'cost' => 4.00,
                'item_type' => 'beverage',
                'type' => 'product',
                'stock_quantity' => 50,
                'min_stock' => 10,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'قهوة عربية',
                'description' => 'قهوة عربية أصيلة مع الحليب',
                'price' => 10.00,
                'cost' => 4.50,
                'item_type' => 'beverage',
                'type' => 'product',
                'stock_quantity' => 80,
                'min_stock' => 15,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],

            // فئة الحلويات (dessert)
            [
                'name' => 'كيك الشوكولاتة',
                'description' => 'قطعة كيك شوكولاتة غنية',
                'price' => 20.00,
                'cost' => 10.00,
                'item_type' => 'dessert',
                'type' => 'product',
                'stock_quantity' => 15,
                'min_stock' => 3,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'آيس كريم فانيليا',
                'description' => 'كوب آيس كريم فانيليا طبيعي',
                'price' => 12.00,
                'cost' => 6.00,
                'item_type' => 'dessert',
                'type' => 'product',
                'stock_quantity' => 25,
                'min_stock' => 5,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'تشيز كيك',
                'description' => 'تشيز كيك كريمي بالفراولة',
                'price' => 25.00,
                'cost' => 12.00,
                'item_type' => 'dessert',
                'type' => 'product',
                'stock_quantity' => 12,
                'min_stock' => 3,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],

            // فئة الأطباق الرئيسية (main_course)
            [
                'name' => 'ستيك لحم مشوي',
                'description' => 'ستيك لحم طري مع البطاطس المشوية',
                'price' => 45.00,
                'cost' => 25.00,
                'item_type' => 'main_course',
                'type' => 'product',
                'stock_quantity' => 20,
                'min_stock' => 4,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'سمك مشوي',
                'description' => 'سمك طازج مشوي مع الخضار',
                'price' => 40.00,
                'cost' => 22.00,
                'item_type' => 'main_course',
                'type' => 'product',
                'stock_quantity' => 15,
                'min_stock' => 3,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'دجاج مشوي',
                'description' => 'نصف دجاجة مشوية مع الأرز',
                'price' => 30.00,
                'cost' => 16.00,
                'item_type' => 'main_course',
                'type' => 'product',
                'stock_quantity' => 25,
                'min_stock' => 5,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],

            // فئة الوجبات المتكاملة (combo)
            [
                'name' => 'وجبة برجر مع بطاطس ومشروب',
                'description' => 'برجر + بطاطس مقلية + مشروب غازي',
                'price' => 28.00,
                'cost' => 15.00,
                'item_type' => 'combo',
                'type' => 'product',
                'stock_quantity' => 35,
                'min_stock' => 8,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'وجبة دجاج عائلية',
                'description' => 'دجاج مقلي + أرز + سلطة + خبز',
                'price' => 55.00,
                'cost' => 30.00,
                'item_type' => 'combo',
                'type' => 'product',
                'stock_quantity' => 18,
                'min_stock' => 4,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'وجبة بيتزا مع مقبلات',
                'description' => 'بيتزا وسط + مقبلات + مشروبين',
                'price' => 48.00,
                'cost' => 26.00,
                'item_type' => 'combo',
                'type' => 'product',
                'stock_quantity' => 22,
                'min_stock' => 5,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],

            // فئة أخرى (other)
            [
                'name' => 'خدمة التوصيل',
                'description' => 'رسوم توصيل الطلبات للمنازل',
                'price' => 5.00,
                'cost' => 0.00,
                'item_type' => 'other',
                'type' => 'service',
                'stock_quantity' => null,
                'min_stock' => null,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ],
            [
                'name' => 'كيس إضافي',
                'description' => 'كيس إضافي للطلبات الخارجية',
                'price' => 1.00,
                'cost' => 0.50,
                'item_type' => 'other',
                'type' => 'product',
                'stock_quantity' => 200,
                'min_stock' => 50,
                'account_id' => $salesAccount->id,
                'is_active' => true
            ]
        ];

        // إضافة المنتجات إلى قاعدة البيانات
        foreach ($products as $productData) {
            Product::create($productData);
        }

        $this->command->info('تم إضافة ' . count($products) . ' منتج تجريبي بفئات مختلفة بنجاح!');
        $this->command->info('الفئات المضافة:');
        $this->command->info('- food (طعام): 3 منتجات');
        $this->command->info('- appetizer (مقبلات): 3 منتجات');
        $this->command->info('- beverage (مشروبات): 3 منتجات');
        $this->command->info('- dessert (حلويات): 3 منتجات');
        $this->command->info('- main_course (أطباق رئيسية): 3 منتجات');
        $this->command->info('- combo (وجبات متكاملة): 3 منتجات');
        $this->command->info('- other (أخرى): 2 منتج');
    }
}