<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Company;
use App\Models\Customer;
use App\Models\Product;
use App\Models\User;
use App\Models\ZatcaSettings;
use Illuminate\Support\Facades\Hash;

class InitialDataSeeder extends Seeder
{
    public function run(): void
    {
        // إنشاء مستخدم أساسي
        $user = User::create([
            'name' => 'مدير النظام',
            'email' => 'admin@brima.com',
            'password' => Hash::make('password123'),
            'email_verified_at' => now(),
        ]);

        // إنشاء شركة نموذجية
        $company = Company::create([
            'name' => 'شركة بريما للتجارة',
            'vat_number' => '300000000000003',
            'cr_number' => '1010000000',
            'city' => 'الرياض',
            'district' => 'الملز',
            'street' => 'شارع الملك فهد',
            'building_number' => '1234',
            'additional_number' => '5678',
            'postal_code' => '12345',
            'unit_number' => '101',
            'email' => 'info@brima.com',
            'phone' => '+966501234567',
            'website' => 'https://brima.com',
            'is_active' => true,
        ]);

        // إنشاء إعدادات ZATCA للشركة
        ZatcaSettings::create([
            'company_id' => $company->id,
            'connection_type' => 'clearance',
            'environment' => 'sandbox',
            'invoice_counter' => 0,
            'is_active' => false,
            'connection_status' => 'disconnected',
        ]);

        // إنشاء عملاء نموذجيين
        $customers = [
            [
                'name' => 'محمد أحمد السعودي',
                'customer_type' => 'individual',
                'national_id' => '1234567890',
                'city' => 'الرياض',
                'district' => 'النخيل',
                'street' => 'شارع العليا',
                'building_number' => '5678',
                'additional_number' => '9012',
                'postal_code' => '11564',
                'email' => 'mohammed@example.com',
                'phone' => '+966501111111',
            ],
            [
                'name' => 'شركة التقنية المتقدمة',
                'customer_type' => 'business',
                'vat_number' => '300000000000004',
                'cr_number' => '1010000001',
                'city' => 'جدة',
                'district' => 'الروضة',
                'street' => 'طريق الملك عبدالعزيز',
                'building_number' => '2468',
                'additional_number' => '1357',
                'postal_code' => '21423',
                'email' => 'info@tech-company.com',
                'phone' => '+966502222222',
            ],
            [
                'name' => 'فاطمة خالد العتيبي',
                'customer_type' => 'individual',
                'national_id' => '2345678901',
                'city' => 'الدمام',
                'district' => 'الفيصلية',
                'street' => 'شارع الأمير محمد بن فهد',
                'building_number' => '3579',
                'additional_number' => '2468',
                'postal_code' => '31411',
                'email' => 'fatima@example.com',
                'phone' => '+966503333333',
            ]
        ];

        foreach ($customers as $customerData) {
            Customer::create($customerData);
        }

        // إنشاء منتجات وخدمات نموذجية
        $products = [
            [
                'name' => 'جهاز كمبيوتر محمول',
                'name_en' => 'Laptop Computer',
                'description' => 'جهاز كمبيوتر محمول عالي الأداء للأعمال',
                'sku' => 'LAP001',
                'barcode' => '1234567890123',
                'type' => 'product',
                'price' => 2500.00,
                'price_with_tax' => 2875.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 50,
                'min_stock' => 10,
                'unit' => 'قطعة',
                'zatca_category_code' => 'ELEC001',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'name' => 'خدمة الصيانة التقنية',
                'name_en' => 'Technical Maintenance Service',
                'description' => 'خدمة صيانة شاملة للأجهزة التقنية',
                'sku' => 'SRV001',
                'type' => 'service',
                'price' => 150.00,
                'price_with_tax' => 172.50,
                'tax_rate' => 15.00,
                'stock_quantity' => 0,
                'min_stock' => 0,
                'unit' => 'ساعة',
                'zatca_category_code' => 'SRV001',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'name' => 'ماوس لاسلكي',
                'name_en' => 'Wireless Mouse',
                'description' => 'ماوس لاسلكي عالي الدقة',
                'sku' => 'MOU001',
                'barcode' => '2345678901234',
                'type' => 'product',
                'price' => 45.00,
                'price_with_tax' => 51.75,
                'tax_rate' => 15.00,
                'stock_quantity' => 200,
                'min_stock' => 50,
                'unit' => 'قطعة',
                'zatca_category_code' => 'ELEC002',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'name' => 'لوحة مفاتيح ميكانيكية',
                'name_en' => 'Mechanical Keyboard',
                'description' => 'لوحة مفاتيح ميكانيكية للألعاب والعمل',
                'sku' => 'KEY001',
                'barcode' => '3456789012345',
                'type' => 'product',
                'price' => 120.00,
                'price_with_tax' => 138.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 75,
                'min_stock' => 15,
                'unit' => 'قطعة',
                'zatca_category_code' => 'ELEC003',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'name' => 'استشارة تقنية',
                'name_en' => 'Technical Consultation',
                'description' => 'خدمة استشارة تقنية متخصصة',
                'sku' => 'CON001',
                'type' => 'service',
                'price' => 300.00,
                'price_with_tax' => 345.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 0,
                'min_stock' => 0,
                'unit' => 'جلسة',
                'zatca_category_code' => 'CON001',
                'is_taxable' => true,
                'is_active' => true,
            ]
        ];

        foreach ($products as $productData) {
            Product::create($productData);
        }

        $this->command->info('تم إنشاء البيانات الأولية بنجاح!');
        $this->command->info('بيانات تسجيل الدخول:');
        $this->command->info('البريد الإلكتروني: admin@brima.com');
        $this->command->info('كلمة المرور: password123');
    }
}
