<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Customer;

class CustomerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // عملاء أفراد
        Customer::create([
            'name' => 'عبدالله محمد الأحمد',
            'customer_type' => 'individual',
            'national_id' => '1234567890',
            
            // العنوان الوطني
            'city' => 'الرياض',
            'district' => 'حي النخيل',
            'street' => 'شارع الأمير سلطان',
            'building_number' => '2345',
            'additional_number' => '6789',
            'postal_code' => '11634',
            'unit_number' => '5',
            
            // بيانات الاتصال
            'email' => 'abdullah.ahmed@gmail.com',
            'phone' => '+966501111111',
            
            'notes' => 'عميل مميز',
            'is_active' => true,
        ]);

        Customer::create([
            'name' => 'فاطمة علي السالم',
            'customer_type' => 'individual',
            'national_id' => '2345678901',
            
            // العنوان الوطني
            'city' => 'جدة',
            'district' => 'حي الصفا',
            'street' => 'شارع فلسطين',
            'building_number' => '3456',
            'additional_number' => '7890',
            'postal_code' => '21452',
            'unit_number' => '12',
            
            // بيانات الاتصال
            'email' => 'fatima.salem@outlook.com',
            'phone' => '+966502222222',
            
            'notes' => 'عميل جديد',
            'is_active' => true,
        ]);

        Customer::create([
            'name' => 'خالد سعد الغامدي',
            'customer_type' => 'individual',
            'national_id' => '3456789012',
            
            // العنوان الوطني
            'city' => 'الدمام',
            'district' => 'حي الشاطئ',
            'street' => 'شارع الملك فهد',
            'building_number' => '4567',
            'additional_number' => '8901',
            'postal_code' => '31952',
            'unit_number' => '8',
            
            // بيانات الاتصال
            'email' => 'khalid.ghamdi@hotmail.com',
            'phone' => '+966503333333',
            
            'notes' => 'يفضل التعامل عبر الواتساب',
            'is_active' => true,
        ]);

        // عملاء شركات
        Customer::create([
            'name' => 'شركة التجارة الحديثة المحدودة',
            'customer_type' => 'business',
            'vat_number' => '300111222333003',
            'cr_number' => '1010111222',
            
            // العنوان الوطني
            'city' => 'الرياض',
            'district' => 'حي العليا',
            'street' => 'طريق الملك فهد',
            'building_number' => '5678',
            'additional_number' => '9012',
            'postal_code' => '11564',
            'unit_number' => '501',
            
            // بيانات الاتصال
            'email' => 'procurement@modern-trade.com',
            'phone' => '+966114444444',
            
            'notes' => 'شركة كبيرة - شروط دفع 30 يوم',
            'is_active' => true,
        ]);

        Customer::create([
            'name' => 'مؤسسة الخدمات التقنية',
            'customer_type' => 'business',
            'vat_number' => '301222333444003',
            'cr_number' => '1010222333',
            
            // العنوان الوطني
            'city' => 'جدة',
            'district' => 'حي الروضة',
            'street' => 'شارع التحلية',
            'building_number' => '6789',
            'additional_number' => '0123',
            'postal_code' => '21589',
            'unit_number' => '201',
            
            // بيانات الاتصال
            'email' => 'info@tech-services.com',
            'phone' => '+966125555555',
            
            'notes' => 'متخصصون في الحلول التقنية',
            'is_active' => true,
        ]);

        Customer::create([
            'name' => 'شركة الصناعات الغذائية الوطنية',
            'customer_type' => 'business',
            'vat_number' => '302333444555003',
            'cr_number' => '1010333444',
            
            // العنوان الوطني
            'city' => 'الدمام',
            'district' => 'المنطقة الصناعية الثانية',
            'street' => 'شارع الصناعة',
            'building_number' => '7890',
            'additional_number' => '1234',
            'postal_code' => '31952',
            'unit_number' => '1',
            
            // بيانات الاتصال
            'email' => 'orders@national-foods.com',
            'phone' => '+966136666666',
            
            'notes' => 'طلبات كبيرة - تسليم شهري',
            'is_active' => true,
        ]);

        // عميل غير نشط للاختبار
        Customer::create([
            'name' => 'عميل غير نشط',
            'customer_type' => 'individual',
            'national_id' => '9876543210',
            
            // العنوان الوطني
            'city' => 'مكة المكرمة',
            'district' => 'حي الشوقية',
            'street' => 'شارع إبراهيم الخليل',
            'building_number' => '1111',
            'additional_number' => '2222',
            'postal_code' => '24231',
            
            // بيانات الاتصال
            'email' => 'inactive@test.com',
            'phone' => '+966509999999',
            
            'notes' => 'حساب معطل مؤقتاً',
            'is_active' => false,
        ]);

        // عميل للاختبار بدون تفاصيل إضافية
        Customer::create([
            'name' => 'سعد محمد العتيبي',
            'customer_type' => 'individual',
            'national_id' => '4567890123',
            
            // العنوان الوطني المبسط
            'city' => 'الرياض',
            'district' => 'حي المروج',
            'street' => 'شارع عثمان بن عفان',
            'building_number' => '8888',
            'additional_number' => '9999',
            'postal_code' => '11564',
            
            // بيانات اتصال محدودة
            'phone' => '+966508888888',
            
            'is_active' => true,
        ]);
    }
}
