<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Company;

class CompanySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // الشركة الرئيسية للاختبار
        Company::firstOrCreate(
            ['vat_number' => '310123456789003'],
            [
                'name' => 'شركة بريما للتقنية المحدودة',
                'cr_number' => '1010123456',
                
                // العنوان الوطني السعودي الكامل
                'city' => 'الرياض',
                'district' => 'حي الملك فهد',
                'street' => 'شارع الملك عبدالعزيز',
                'building_number' => '1234',
                'additional_number' => '5678',
                'postal_code' => '11564',
                'unit_number' => '101',
                
                // بيانات الاتصال
                'email' => 'info@brima-tech.com',
                'phone' => '+966112345678',
                'website' => 'https://brima-tech.com',
                
                'is_active' => true,
            ]
        );

        // شركة فرعية للاختبار
        Company::firstOrCreate(
            ['vat_number' => '300987654321003'],
            [
                'name' => 'مؤسسة الاختبار التجارية',
                'cr_number' => '1010987654',
                
                // العنوان الوطني
                'city' => 'جدة',
                'district' => 'حي البلد',
                'street' => 'شارع الأمير محمد بن عبدالعزيز',
                'building_number' => '4567',
                'additional_number' => '1234',
                'postal_code' => '21589',
                'unit_number' => '202',
                
                // بيانات الاتصال
                'email' => 'info@test-company.com',
                'phone' => '+966126789012',
                'website' => 'https://test-company.com',
                
                'is_active' => true,
            ]
        );

        // شركة استشارات للاختبار
        Company::firstOrCreate(
            ['vat_number' => '311456789012003'],
            [
                'name' => 'شركة الاستشارات المتقدمة للتكنولوجيا',
                'cr_number' => '1010456789',
                
                // العنوان الوطني
                'city' => 'الدمام',
                'district' => 'حي الفيصلية',
                'street' => 'شارع الملك سعود',
                'building_number' => '7890',
                'additional_number' => '4321',
                'postal_code' => '31952',
                'unit_number' => '301',
                
                // بيانات الاتصال
                'email' => 'contact@advanced-consulting.com',
                'phone' => '+966138901234',
                'website' => 'https://advanced-consulting.com',
                
                'is_active' => true,
            ]
        );
    }
}
