<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // التحقق من وجود فئات مسبقاً
        if (Category::count() > 0) {
            return;
        }

        $categories = [
            [
                'name' => 'مأكولات',
                'name_en' => 'Food',
                'description' => 'فئة المأكولات الرئيسية',
                'code' => 'FOOD',
                'color' => '#28a745',
                'icon' => 'fas fa-utensils',
                'type' => 'product',
                'is_active' => true,
                'sort_order' => 1,
                'children' => [
                    [
                        'name' => 'أطباق رئيسية',
                        'name_en' => 'Main Dishes',
                        'code' => 'MAIN',
                        'color' => '#007bff',
                        'icon' => 'fas fa-drumstick-bite',
                        'sort_order' => 1,
                    ],
                    [
                        'name' => 'مقبلات',
                        'name_en' => 'Appetizers',
                        'code' => 'APPETIZERS',
                        'color' => '#ffc107',
                        'icon' => 'fas fa-cookie-bite',
                        'sort_order' => 2,
                    ],
                    [
                        'name' => 'حلويات',
                        'name_en' => 'Desserts',
                        'code' => 'DESSERTS',
                        'color' => '#e83e8c',
                        'icon' => 'fas fa-birthday-cake',
                        'sort_order' => 3,
                    ],
                ]
            ],
            [
                'name' => 'مشروبات',
                'name_en' => 'Beverages',
                'description' => 'فئة المشروبات',
                'code' => 'BEVERAGES',
                'color' => '#17a2b8',
                'icon' => 'fas fa-coffee',
                'type' => 'product',
                'is_active' => true,
                'sort_order' => 2,
                'children' => [
                    [
                        'name' => 'مشروبات ساخنة',
                        'name_en' => 'Hot Beverages',
                        'code' => 'HOT_DRINKS',
                        'color' => '#dc3545',
                        'icon' => 'fas fa-mug-hot',
                        'sort_order' => 1,
                    ],
                    [
                        'name' => 'مشروبات باردة',
                        'name_en' => 'Cold Beverages',
                        'code' => 'COLD_DRINKS',
                        'color' => '#20c997',
                        'icon' => 'fas fa-glass-whiskey',
                        'sort_order' => 2,
                    ],
                    [
                        'name' => 'عصائر طبيعية',
                        'name_en' => 'Fresh Juices',
                        'code' => 'JUICES',
                        'color' => '#fd7e14',
                        'icon' => 'fas fa-glass-martini-alt',
                        'sort_order' => 3,
                    ],
                ]
            ],
            [
                'name' => 'خدمات',
                'name_en' => 'Services',
                'description' => 'فئة الخدمات',
                'code' => 'SERVICES',
                'color' => '#6f42c1',
                'icon' => 'fas fa-concierge-bell',
                'type' => 'service',
                'is_active' => true,
                'sort_order' => 3,
                'children' => [
                    [
                        'name' => 'خدمة التوصيل',
                        'name_en' => 'Delivery Service',
                        'code' => 'DELIVERY',
                        'color' => '#28a745',
                        'icon' => 'fas fa-truck',
                        'sort_order' => 1,
                    ],
                    [
                        'name' => 'خدمة الطاولة',
                        'name_en' => 'Table Service',
                        'code' => 'TABLE_SERVICE',
                        'color' => '#007bff',
                        'icon' => 'fas fa-table',
                        'sort_order' => 2,
                    ],
                ]
            ],
        ];

        foreach ($categories as $categoryData) {
            $children = $categoryData['children'] ?? [];
            unset($categoryData['children']);
            
            $category = Category::create($categoryData);
            
            foreach ($children as $childData) {
                $childData['parent_id'] = $category->id;
                $childData['level'] = 1;
                $childData['path'] = $category->id;
                $childData['type'] = $category->type;
                $childData['is_active'] = true;
                
                Category::create($childData);
            }
        }
    }
}