<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // إنشاء مستخدم مدير افتراضي
        User::firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name' => 'مدير النظام',
                'password' => Hash::make('password'),
                'phone' => '0123456789',
                'role' => 'admin',
                'is_active' => true,
            ]
        );

        // إنشاء مستخدم مدير إضافي
        User::firstOrCreate(
            ['email' => 'manager@example.com'],
            [
                'name' => 'مدير المبيعات',
                'password' => Hash::make('password'),
                'phone' => '0987654321',
                'role' => 'manager',
                'is_active' => true,
            ]
        );

        // إنشاء موظف
        User::firstOrCreate(
            ['email' => 'employee@example.com'],
            [
                'name' => 'موظف المبيعات',
                'password' => Hash::make('password'),
                'phone' => '0555123456',
                'role' => 'employee',
                'is_active' => true,
            ]
        );
    }
}