<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Account;
use App\Models\CostCenter;
use App\Models\BankAccount;

class AccountingSeeder extends Seeder
{
    public function run()
    {
        $this->createChartOfAccounts();
        $this->createCostCenters();
        $this->createBankAccounts();
    }

    private function createChartOfAccounts()
    {
        // الأصول
        $assets = Account::create([
            'code' => '1000',
            'name' => 'الأصول',
            'name_en' => 'Assets',
            'type' => 'asset',
            'subtype' => 'current_asset',
            'debit_credit' => 'debit',
            'level' => 1,
            'is_control_account' => true
        ]);

        // الأصول المتداولة
        $currentAssets = Account::create([
            'code' => '1100',
            'name' => 'الأصول المتداولة',
            'name_en' => 'Current Assets',
            'type' => 'asset',
            'subtype' => 'current_asset',
            'parent_id' => $assets->id,
            'debit_credit' => 'debit',
            'level' => 2,
            'is_control_account' => true
        ]);

        // النقدية والبنوك
        Account::create([
            'code' => '1110',
            'name' => 'الصندوق',
            'name_en' => 'Cash',
            'type' => 'asset',
            'subtype' => 'current_asset',
            'parent_id' => $currentAssets->id,
            'debit_credit' => 'debit',
            'level' => 3,
            'is_cash_account' => true,
            'opening_balance' => 10000
        ]);

        Account::create([
            'code' => '1120',
            'name' => 'البنك الأهلي التجاري',
            'name_en' => 'National Commercial Bank',
            'type' => 'asset',
            'subtype' => 'current_asset',
            'parent_id' => $currentAssets->id,
            'debit_credit' => 'debit',
            'level' => 3,
            'is_bank_account' => true,
            'opening_balance' => 50000
        ]);

        Account::create([
            'code' => '1130',
            'name' => 'بنك الراجحي',
            'name_en' => 'Al Rajhi Bank',
            'type' => 'asset',
            'subtype' => 'current_asset',
            'parent_id' => $currentAssets->id,
            'debit_credit' => 'debit',
            'level' => 3,
            'is_bank_account' => true,
            'opening_balance' => 75000
        ]);

        // العملاء والذمم المدينة
        Account::create([
            'code' => '1210',
            'name' => 'الذمم المدينة - العملاء',
            'name_en' => 'Accounts Receivable - Customers',
            'type' => 'asset',
            'subtype' => 'current_asset',
            'parent_id' => $currentAssets->id,
            'debit_credit' => 'debit',
            'level' => 3
        ]);

        // المخزون
        Account::create([
            'code' => '1310',
            'name' => 'مخزون البضائع',
            'name_en' => 'Inventory',
            'type' => 'asset',
            'subtype' => 'current_asset',
            'parent_id' => $currentAssets->id,
            'debit_credit' => 'debit',
            'level' => 3,
            'opening_balance' => 100000
        ]);

        // الأصول الثابتة
        $fixedAssets = Account::create([
            'code' => '1500',
            'name' => 'الأصول الثابتة',
            'name_en' => 'Fixed Assets',
            'type' => 'asset',
            'subtype' => 'fixed_asset',
            'parent_id' => $assets->id,
            'debit_credit' => 'debit',
            'level' => 2,
            'is_control_account' => true
        ]);

        Account::create([
            'code' => '1510',
            'name' => 'المباني والمنشآت',
            'name_en' => 'Buildings',
            'type' => 'asset',
            'subtype' => 'fixed_asset',
            'parent_id' => $fixedAssets->id,
            'debit_credit' => 'debit',
            'level' => 3,
            'opening_balance' => 500000
        ]);

        Account::create([
            'code' => '1520',
            'name' => 'المعدات والآلات',
            'name_en' => 'Equipment',
            'type' => 'asset',
            'subtype' => 'fixed_asset',
            'parent_id' => $fixedAssets->id,
            'debit_credit' => 'debit',
            'level' => 3,
            'opening_balance' => 200000
        ]);

        // الخصوم
        $liabilities = Account::create([
            'code' => '2000',
            'name' => 'الخصوم',
            'name_en' => 'Liabilities',
            'type' => 'liability',
            'subtype' => 'current_liability',
            'debit_credit' => 'credit',
            'level' => 1,
            'is_control_account' => true
        ]);

        // الخصوم المتداولة
        $currentLiabilities = Account::create([
            'code' => '2100',
            'name' => 'الخصوم المتداولة',
            'name_en' => 'Current Liabilities',
            'type' => 'liability',
            'subtype' => 'current_liability',
            'parent_id' => $liabilities->id,
            'debit_credit' => 'credit',
            'level' => 2,
            'is_control_account' => true
        ]);

        Account::create([
            'code' => '2110',
            'name' => 'الذمم الدائنة - الموردين',
            'name_en' => 'Accounts Payable - Suppliers',
            'type' => 'liability',
            'subtype' => 'current_liability',
            'parent_id' => $currentLiabilities->id,
            'debit_credit' => 'credit',
            'level' => 3
        ]);

        Account::create([
            'code' => '2120',
            'name' => 'الضرائب المستحقة',
            'name_en' => 'Accrued Taxes',
            'type' => 'liability',
            'subtype' => 'current_liability',
            'parent_id' => $currentLiabilities->id,
            'debit_credit' => 'credit',
            'level' => 3
        ]);

        // حقوق الملكية
        $equity = Account::create([
            'code' => '3000',
            'name' => 'حقوق الملكية',
            'name_en' => 'Equity',
            'type' => 'equity',
            'subtype' => 'capital',
            'debit_credit' => 'credit',
            'level' => 1,
            'is_control_account' => true
        ]);

        Account::create([
            'code' => '3100',
            'name' => 'رأس المال',
            'name_en' => 'Capital',
            'type' => 'equity',
            'subtype' => 'capital',
            'parent_id' => $equity->id,
            'debit_credit' => 'credit',
            'level' => 2,
            'opening_balance' => 800000
        ]);

        Account::create([
            'code' => '3200',
            'name' => 'الأرباح المحتجزة',
            'name_en' => 'Retained Earnings',
            'type' => 'equity',
            'subtype' => 'retained_earnings',
            'parent_id' => $equity->id,
            'debit_credit' => 'credit',
            'level' => 2
        ]);

        // الإيرادات
        $revenue = Account::create([
            'code' => '4000',
            'name' => 'الإيرادات',
            'name_en' => 'Revenue',
            'type' => 'revenue',
            'subtype' => 'operating_revenue',
            'debit_credit' => 'credit',
            'level' => 1,
            'is_control_account' => true
        ]);

        Account::create([
            'code' => '4100',
            'name' => 'إيرادات المبيعات',
            'name_en' => 'Sales Revenue',
            'type' => 'revenue',
            'subtype' => 'operating_revenue',
            'parent_id' => $revenue->id,
            'debit_credit' => 'credit',
            'level' => 2
        ]);

        Account::create([
            'code' => '4200',
            'name' => 'إيرادات أخرى',
            'name_en' => 'Other Revenue',
            'type' => 'revenue',
            'subtype' => 'other_revenue',
            'parent_id' => $revenue->id,
            'debit_credit' => 'credit',
            'level' => 2
        ]);

        // المصروفات
        $expenses = Account::create([
            'code' => '5000',
            'name' => 'المصروفات',
            'name_en' => 'Expenses',
            'type' => 'expense',
            'subtype' => 'operating_expense',
            'debit_credit' => 'debit',
            'level' => 1,
            'is_control_account' => true
        ]);

        // تكلفة البضاعة المباعة
        Account::create([
            'code' => '5100',
            'name' => 'تكلفة البضاعة المباعة',
            'name_en' => 'Cost of Goods Sold',
            'type' => 'expense',
            'subtype' => 'cost_of_goods_sold',
            'parent_id' => $expenses->id,
            'debit_credit' => 'debit',
            'level' => 2
        ]);

        // المصروفات التشغيلية
        $operatingExpenses = Account::create([
            'code' => '5200',
            'name' => 'المصروفات التشغيلية',
            'name_en' => 'Operating Expenses',
            'type' => 'expense',
            'subtype' => 'operating_expense',
            'parent_id' => $expenses->id,
            'debit_credit' => 'debit',
            'level' => 2,
            'is_control_account' => true
        ]);

        Account::create([
            'code' => '5210',
            'name' => 'رواتب وأجور',
            'name_en' => 'Salaries and Wages',
            'type' => 'expense',
            'subtype' => 'operating_expense',
            'parent_id' => $operatingExpenses->id,
            'debit_credit' => 'debit',
            'level' => 3
        ]);

        Account::create([
            'code' => '5220',
            'name' => 'إيجارات',
            'name_en' => 'Rent',
            'type' => 'expense',
            'subtype' => 'operating_expense',
            'parent_id' => $operatingExpenses->id,
            'debit_credit' => 'debit',
            'level' => 3
        ]);

        Account::create([
            'code' => '5230',
            'name' => 'كهرباء ومياه',
            'name_en' => 'Utilities',
            'type' => 'expense',
            'subtype' => 'operating_expense',
            'parent_id' => $operatingExpenses->id,
            'debit_credit' => 'debit',
            'level' => 3
        ]);

        // تحديث المسارات لجميع الحسابات
        $this->updateAccountPaths();
    }

    private function createCostCenters()
    {
        $administration = CostCenter::create([
            'code' => 'ADM001',
            'name' => 'الإدارة العامة',
            'name_en' => 'General Administration',
            'description' => 'مركز تكلفة الإدارة العامة',
            'budget_amount' => 50000
        ]);

        CostCenter::create([
            'code' => 'SAL001',
            'name' => 'قسم المبيعات',
            'name_en' => 'Sales Department',
            'description' => 'مركز تكلفة قسم المبيعات',
            'budget_amount' => 30000
        ]);

        CostCenter::create([
            'code' => 'PUR001',
            'name' => 'قسم المشتريات',
            'name_en' => 'Purchasing Department',
            'description' => 'مركز تكلفة قسم المشتريات',
            'budget_amount' => 20000
        ]);

        CostCenter::create([
            'code' => 'WAR001',
            'name' => 'المستودعات',
            'name_en' => 'Warehouses',
            'description' => 'مركز تكلفة المستودعات',
            'budget_amount' => 15000
        ]);
    }

    private function createBankAccounts()
    {
        $nbc = Account::where('code', '1120')->first();
        if ($nbc) {
            BankAccount::create([
                'account_id' => $nbc->id,
                'bank_name' => 'البنك الأهلي التجاري',
                'account_number' => '123456789',
                'iban' => 'SA1234567890123456789012',
                'swift_code' => 'NCBKSARI',
                'branch' => 'الفرع الرئيسي',
                'currency' => 'SAR',
                'opening_balance' => 50000,
                'current_balance' => 50000
            ]);
        }

        $rajhi = Account::where('code', '1130')->first();
        if ($rajhi) {
            BankAccount::create([
                'account_id' => $rajhi->id,
                'bank_name' => 'بنك الراجحي',
                'account_number' => '987654321',
                'iban' => 'SA9876543210987654321098',
                'swift_code' => 'RJHISARI',
                'branch' => 'فرع الملك فهد',
                'currency' => 'SAR',
                'opening_balance' => 75000,
                'current_balance' => 75000
            ]);
        }
    }

    private function updateAccountPaths()
    {
        $accounts = Account::whereNull('parent_id')->get();
        
        foreach ($accounts as $account) {
            $this->updateAccountPath($account);
        }
    }

    private function updateAccountPath($account, $path = '')
    {
        $currentPath = $path ? $path . ',' . $account->id : $account->id;
        $account->update(['path' => $currentPath]);

        foreach ($account->children as $child) {
            $this->updateAccountPath($child, $currentPath);
        }
    }
}