<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // حذف حقل category القديم لأننا نستخدم الآن category_id
            if (Schema::hasColumn('products', 'category')) {
                $table->dropColumn('category');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // إعادة إضافة حقل category في حالة التراجع
            if (!Schema::hasColumn('products', 'category')) {
                $table->string('category')->nullable()->after('type')->comment('تصنيف المنتج');
            }
        });
    }
};
