<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            // إضافة حقول نوع العملية التجارية لـ ZATCA Phase 2
            $table->boolean('is_third_party')->default(false)->after('notes'); // طرف ثالث
            $table->boolean('is_nominal')->default(false)->after('is_third_party'); // توريد اسمي
            $table->boolean('is_export')->default(false)->after('is_nominal'); // تصدير
            $table->boolean('is_summary')->default(false)->after('is_export'); // فاتورة إجمالية
            $table->boolean('is_self_billed')->default(false)->after('is_summary'); // فاتورة ذاتية
            
            // إضافة حقول إضافية لدعم أنواع الإشعارات
            $table->string('credit_debit_reason')->nullable()->after('is_self_billed'); // سبب الإشعار الدائن/المدين
            
            // تحديث enum type لدعم أنواع الإشعارات
            $table->enum('type', ['standard', 'simplified', 'credit_note', 'debit_note', 'credit', 'debit'])->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn([
                'is_third_party',
                'is_nominal', 
                'is_export',
                'is_summary',
                'is_self_billed',
                'credit_debit_reason'
            ]);
            
            // إعادة enum الأصلي
            $table->enum('type', ['standard', 'simplified'])->change();
        });
    }
};