<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            // Only add fields that don't exist yet
            
            // Enhanced QR Code field (in addition to existing 'qr_code')
            if (!Schema::hasColumn('invoices', 'qr_code_data')) {
                $table->text('qr_code_data')->nullable()->after('qr_code')->comment('Base64 encoded QR Code data for Phase 2');
            }
            
            // QR Code image path
            if (!Schema::hasColumn('invoices', 'qr_code_image_path')) {
                $table->string('qr_code_image_path')->nullable()->comment('Path to QR Code image file');
            }
            
            // Signed XML path
            if (!Schema::hasColumn('invoices', 'signed_xml_path')) {
                $table->string('signed_xml_path')->nullable()->comment('Path to signed XML file');
            }
        });
        
        // Add indexes in separate operation to avoid conflicts
        try {
            Schema::table('invoices', function (Blueprint $table) {
                $table->index('instruction_id');
            });
        } catch (\Exception $e) {
            // Index might already exist
        }
        
        try {
            Schema::table('invoices', function (Blueprint $table) {
                $table->index('invoice_counter');
            });
        } catch (\Exception $e) {
            // Index might already exist
        }
        
        try {
            Schema::table('invoices', function (Blueprint $table) {
                $table->index('invoice_hash');
            });
        } catch (\Exception $e) {
            // Index might already exist
        }
        
        try {
            Schema::table('invoices', function (Blueprint $table) {
                $table->index('sent_to_zatca_at');
            });
        } catch (\Exception $e) {
            // Index might already exist
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            // Only drop columns that were added by this migration
            if (Schema::hasColumn('invoices', 'qr_code_data')) {
                $table->dropColumn('qr_code_data');
            }
            if (Schema::hasColumn('invoices', 'qr_code_image_path')) {
                $table->dropColumn('qr_code_image_path');
            }
            if (Schema::hasColumn('invoices', 'signed_xml_path')) {
                $table->dropColumn('signed_xml_path');
            }
        });
        
        // Drop indexes (safely)
        try {
            Schema::table('invoices', function (Blueprint $table) {
                $table->dropIndex(['instruction_id']);
            });
        } catch (\Exception $e) {
            // Index might not exist
        }
        
        try {
            Schema::table('invoices', function (Blueprint $table) {
                $table->dropIndex(['invoice_counter']);
            });
        } catch (\Exception $e) {
            // Index might not exist
        }
        
        try {
            Schema::table('invoices', function (Blueprint $table) {
                $table->dropIndex(['invoice_hash']);
            });
        } catch (\Exception $e) {
            // Index might not exist
        }
        
        try {
            Schema::table('invoices', function (Blueprint $table) {
                $table->dropIndex(['sent_to_zatca_at']);
            });
        } catch (\Exception $e) {
            // Index might not exist
        }
    }
};
