<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // تحقق من وجود العمود قبل الإضافة
            if (!Schema::hasColumn('products', 'preparation_time')) {
                $table->integer('preparation_time')->nullable()->after('description');
            }
            if (!Schema::hasColumn('products', 'is_available')) {
                $table->boolean('is_available')->default(true)->after('preparation_time');
            }
            if (!Schema::hasColumn('products', 'image_url')) {
                $table->string('image_url')->nullable()->after('is_available');
            }
            if (!Schema::hasColumn('products', 'restaurant_category')) {
                $table->string('restaurant_category')->nullable()->after('image_url');
            }
            if (!Schema::hasColumn('products', 'price_with_tax')) {
                $table->decimal('price_with_tax', 10, 2)->nullable()->after('price');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $columns = ['preparation_time', 'is_available', 'image_url', 'restaurant_category', 'price_with_tax'];
            foreach ($columns as $column) {
                if (Schema::hasColumn('products', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
