<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // حقول خاصة بالمطاعم
            $table->enum('item_type', ['food', 'beverage', 'dessert', 'appetizer', 'main_course', 'combo', 'other'])
                  ->default('food')->after('type')->comment('نوع العنصر في المطعم');
            
            $table->text('ingredients')->nullable()->after('description')->comment('المكونات');
            $table->text('allergens')->nullable()->after('ingredients')->comment('المواد المسببة للحساسية');
            
            $table->decimal('calories', 8, 2)->nullable()->after('allergens')->comment('السعرات الحرارية');
            $table->decimal('preparation_time', 5, 2)->nullable()->after('calories')->comment('وقت التحضير بالدقائق');
            
            $table->boolean('is_spicy')->default(false)->after('preparation_time')->comment('حار');
            $table->boolean('is_vegetarian')->default(false)->after('is_spicy')->comment('نباتي');
            $table->boolean('is_vegan')->default(false)->after('is_vegetarian')->comment('نباتي صرف');
            $table->boolean('is_gluten_free')->default(false)->after('is_vegan')->comment('خالي من الجلوتين');
            $table->boolean('is_available')->default(true)->after('is_gluten_free')->comment('متوفر اليوم');
            
            $table->enum('spice_level', ['mild', 'medium', 'hot', 'very_hot'])
                  ->nullable()->after('is_available')->comment('درجة الحرارة');
            
            $table->decimal('size_small_price', 10, 2)->nullable()->after('spice_level')->comment('سعر الحجم الصغير');
            $table->decimal('size_medium_price', 10, 2)->nullable()->after('size_small_price')->comment('سعر الحجم الوسط');
            $table->decimal('size_large_price', 10, 2)->nullable()->after('size_medium_price')->comment('سعر الحجم الكبير');
            
            $table->json('customizations')->nullable()->after('size_large_price')->comment('خيارات التخصيص');
            $table->json('side_dishes')->nullable()->after('customizations')->comment('الأطباق الجانبية');
            
            $table->string('image_url')->nullable()->after('side_dishes')->comment('رابط الصورة');
            $table->integer('sort_order')->default(0)->after('image_url')->comment('ترتيب العرض');
            
            $table->boolean('is_featured')->default(false)->after('sort_order')->comment('منتج مميز');
            $table->boolean('is_combo')->default(false)->after('is_featured')->comment('وجبة كومبو');
            $table->json('combo_items')->nullable()->after('is_combo')->comment('عناصر الكومبو');
            
            $table->text('chef_notes')->nullable()->after('combo_items')->comment('ملاحظات الطباخ');
            $table->text('serving_instructions')->nullable()->after('chef_notes')->comment('تعليمات التقديم');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'item_type',
                'ingredients',
                'allergens',
                'calories',
                'preparation_time',
                'is_spicy',
                'is_vegetarian',
                'is_vegan',
                'is_gluten_free',
                'is_available',
                'spice_level',
                'size_small_price',
                'size_medium_price',
                'size_large_price',
                'customizations',
                'side_dishes',
                'image_url',
                'sort_order',
                'is_featured',
                'is_combo',
                'combo_items',
                'chef_notes',
                'serving_instructions'
            ]);
        });
    }
};