<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            // Make address fields nullable for individual customers
            $table->string('city')->nullable()->change();
            $table->string('district')->nullable()->change();
            $table->string('street')->nullable()->change();
            $table->string('building_number', 10)->nullable()->change();
            $table->string('additional_number', 10)->nullable()->change();
            $table->string('postal_code', 5)->nullable()->change();
            
            // Also make national_id nullable for individuals
            $table->string('national_id', 10)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            // Revert back to NOT NULL (but be careful about existing data)
            $table->string('city')->nullable(false)->change();
            $table->string('district')->nullable(false)->change();
            $table->string('street')->nullable(false)->change();
            $table->string('building_number', 10)->nullable(false)->change();
            $table->string('additional_number', 10)->nullable(false)->change();
            $table->string('postal_code', 5)->nullable(false)->change();
            $table->string('national_id', 10)->nullable(false)->change();
        });
    }
};
