<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // إضافة الحقل الجديد إذا لم يكن موجوداً
        if (!Schema::hasColumn('companies', 'vat_numbers')) {
            Schema::table('companies', function (Blueprint $table) {
                $table->json('vat_numbers')->nullable()->after('vat_number');
            });
        }

        // نقل البيانات الموجودة من vat_number إلى vat_numbers إذا كان الحقل القديم موجوداً
        if (Schema::hasColumn('companies', 'vat_number')) {
            DB::statement("UPDATE companies SET vat_numbers = JSON_ARRAY(vat_number) WHERE vat_number IS NOT NULL");

            // إزالة الفهرس الفريد بشكل آمن
            try {
                DB::statement('ALTER TABLE companies DROP INDEX companies_vat_number_unique');
            } catch (Exception $e) {
                // محاولة بأسماء فهارس أخرى محتملة
                try {
                    DB::statement('ALTER TABLE companies DROP INDEX vat_number_unique');
                } catch (Exception $e2) {
                    try {
                        DB::statement('ALTER TABLE companies DROP INDEX vat_number');
                    } catch (Exception $e3) {
                        // تجاهل إذا لم يكن الفهرس موجوداً
                    }
                }
            }

            // إزالة العمود القديم
            Schema::table('companies', function (Blueprint $table) {
                $table->dropColumn('vat_number');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // إعادة الحقل القديم إذا لم يكن موجوداً
        if (!Schema::hasColumn('companies', 'vat_number')) {
            Schema::table('companies', function (Blueprint $table) {
                $table->string('vat_number')->nullable()->after('name');
            });

            // نقل البيانات من vat_numbers إلى vat_number (الرقم الأول فقط)
            if (Schema::hasColumn('companies', 'vat_numbers')) {
                DB::statement("UPDATE companies SET vat_number = JSON_UNQUOTE(JSON_EXTRACT(vat_numbers, '$[0]')) WHERE vat_numbers IS NOT NULL");
            }

            // إضافة الفهرس الفريد مرة أخرى
            Schema::table('companies', function (Blueprint $table) {
                $table->unique('vat_number');
            });
        }

        // إزالة الحقل الجديد إذا كان موجوداً
        if (Schema::hasColumn('companies', 'vat_numbers')) {
            Schema::table('companies', function (Blueprint $table) {
                $table->dropColumn('vat_numbers');
            });
        }
    }
};
