<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Add missing inventory columns that the code is looking for
            if (!Schema::hasColumn('products', 'current_stock')) {
                $table->decimal('current_stock', 10, 2)->default(0)->after('stock_quantity')->comment('المخزون الحالي');
            }
            if (!Schema::hasColumn('products', 'reorder_level')) {
                $table->decimal('reorder_level', 10, 2)->default(0)->after('min_stock')->comment('مستوى إعادة الطلب');
            }
            if (!Schema::hasColumn('products', 'cost_price')) {
                $table->decimal('cost_price', 10, 2)->default(0)->after('price_with_tax')->comment('سعر التكلفة');
            }
            if (!Schema::hasColumn('products', 'purchase_price')) {
                $table->decimal('purchase_price', 10, 2)->default(0)->after('cost_price')->comment('سعر الشراء');
            }
            if (!Schema::hasColumn('products', 'max_stock')) {
                $table->decimal('max_stock', 10, 2)->default(0)->after('reorder_level')->comment('الحد الأقصى للمخزون');
            }
            if (!Schema::hasColumn('products', 'reserved_stock')) {
                $table->decimal('reserved_stock', 10, 2)->default(0)->after('current_stock')->comment('المخزون المحجوز');
            }
        });
        
        // Copy existing stock data to new columns
        DB::statement('UPDATE products SET current_stock = stock_quantity WHERE current_stock = 0');
        DB::statement('UPDATE products SET reorder_level = min_stock WHERE reorder_level = 0');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'current_stock',
                'reorder_level', 
                'cost_price',
                'purchase_price',
                'max_stock',
                'reserved_stock'
            ]);
        });
    }
};