<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('items', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique()->comment('كود الصنف');
            $table->string('name')->comment('اسم الصنف');
            $table->string('name_en')->nullable()->comment('اسم الصنف بالإنجليزية');
            $table->text('description')->nullable()->comment('وصف الصنف');
            $table->string('barcode')->nullable()->unique()->comment('الباركود');
            $table->string('unit', 20)->default('piece')->comment('وحدة القياس');
            $table->enum('item_type', ['product', 'service', 'raw_material', 'finished_goods', 'consumable'])
                  ->default('product')->comment('نوع الصنف');
            $table->string('category')->nullable()->comment('الفئة');
            $table->string('brand')->nullable()->comment('العلامة التجارية');
            $table->string('model')->nullable()->comment('الموديل');
            $table->decimal('cost_price', 12, 2)->default(0)->comment('سعر التكلفة');
            $table->decimal('selling_price', 12, 2)->default(0)->comment('سعر البيع');
            $table->decimal('minimum_stock', 10, 2)->default(0)->comment('الحد الأدنى للمخزون');
            $table->decimal('maximum_stock', 10, 2)->default(0)->comment('الحد الأقصى للمخزون');
            $table->decimal('current_stock', 10, 2)->default(0)->comment('المخزون الحالي');
            $table->decimal('reserved_stock', 10, 2)->default(0)->comment('المخزون المحجوز');
            $table->string('location')->nullable()->comment('موقع التخزين');
            $table->string('supplier_code')->nullable()->comment('كود المورد');
            $table->decimal('weight', 8, 3)->nullable()->comment('الوزن');
            $table->string('weight_unit', 10)->nullable()->comment('وحدة الوزن');
            $table->string('dimensions')->nullable()->comment('الأبعاد');
            $table->string('color')->nullable()->comment('اللون');
            $table->string('size')->nullable()->comment('المقاس');
            $table->decimal('discount_rate', 5, 2)->default(0)->comment('معدل الخصم');
            $table->decimal('tax_rate', 5, 2)->default(15)->comment('معدل الضريبة');
            $table->string('image_path')->nullable()->comment('مسار الصورة');
            $table->json('additional_info')->nullable()->comment('معلومات إضافية');
            $table->boolean('is_active')->default(true)->comment('نشط');
            $table->boolean('is_stockable')->default(true)->comment('قابل للتتبع في المخزون');
            $table->boolean('is_saleable')->default(true)->comment('قابل للبيع');
            $table->boolean('is_purchasable')->default(true)->comment('قابل للشراء');
            $table->timestamps();

            // Indexes
            $table->index(['is_active']);
            $table->index(['is_stockable']);
            $table->index(['is_saleable']);
            $table->index(['is_purchasable']);
            $table->index(['item_type']);
            $table->index(['category']);
            $table->index(['current_stock']);
            $table->index(['minimum_stock']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('items');
    }
};