<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('suppliers', function (Blueprint $table) {
            // إضافة حقول جديدة لإدارة المديونيات المتقدمة
            if (!Schema::hasColumn('suppliers', 'penalty_rate')) {
                $table->decimal('penalty_rate', 5, 4)->default(0.02)->comment('معدل الغرامة على التأخير');
            }
            if (!Schema::hasColumn('suppliers', 'installment_threshold')) {
                $table->decimal('installment_threshold', 12, 2)->default(50000)->comment('حد المبلغ للتقسيط');
            }
            if (!Schema::hasColumn('suppliers', 'max_installments')) {
                $table->integer('max_installments')->default(3)->comment('أقصى عدد أقساط');
            }
            if (!Schema::hasColumn('suppliers', 'delivery_days')) {
                $table->integer('delivery_days')->default(14)->comment('أيام التسليم المتوقعة');
            }
            if (!Schema::hasColumn('suppliers', 'performance_score')) {
                $table->decimal('performance_score', 5, 2)->default(0)->comment('نقاط الأداء');
            }
            if (!Schema::hasColumn('suppliers', 'risk_level')) {
                $table->enum('risk_level', ['low', 'medium', 'high', 'critical'])->default('low')->comment('مستوى المخاطر');
            }
        });
        
        // إضافة الفهارس بشكل منفصل
        Schema::table('suppliers', function (Blueprint $table) {
            // Add indexes without checking if they exist (Laravel will handle duplicates)
            try {
                $table->index(['penalty_rate'], 'suppliers_penalty_rate_index');
            } catch (\Exception $e) {
                // Index already exists
            }
            try {
                $table->index(['risk_level'], 'suppliers_risk_level_index');
            } catch (\Exception $e) {
                // Index already exists
            }
            try {
                $table->index(['performance_score'], 'suppliers_performance_score_index');
            } catch (\Exception $e) {
                // Index already exists
            }
            try {
                $table->index(['delivery_days'], 'suppliers_delivery_days_index');
            } catch (\Exception $e) {
                // Index already exists
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('suppliers', function (Blueprint $table) {
            $table->dropIndex(['penalty_rate']);
            $table->dropIndex(['risk_level']);
            $table->dropIndex(['performance_score']);
            $table->dropIndex(['delivery_days']);
            
            $table->dropColumn([
                'penalty_rate',
                'installment_threshold',
                'max_installments',
                'delivery_days',
                'performance_score',
                'risk_level'
            ]);
        });
    }
};