<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('suppliers', function (Blueprint $table) {
            // التحقق من وجود الحقول الأساسية وإضافتها إذا لم تكن موجودة
            if (!Schema::hasColumn('suppliers', 'current_balance')) {
                $table->decimal('current_balance', 12, 2)->default(0)->comment('الرصيد الحالي');
            }
            
            if (!Schema::hasColumn('suppliers', 'credit_limit')) {
                $table->decimal('credit_limit', 12, 2)->default(0)->comment('حد الائتمان');
            }
            
            if (!Schema::hasColumn('suppliers', 'payment_terms_days')) {
                $table->integer('payment_terms_days')->default(30)->comment('أيام الدفع');
            }
            
            if (!Schema::hasColumn('suppliers', 'payment_terms')) {
                $table->enum('payment_terms', ['cash', 'credit', 'bank_transfer'])->default('credit')->comment('شروط الدفع');
            }
            
            if (!Schema::hasColumn('suppliers', 'is_active')) {
                $table->boolean('is_active')->default(true)->comment('نشط');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('suppliers', function (Blueprint $table) {
            $table->dropColumn([
                'current_balance',
                'credit_limit', 
                'payment_terms_days',
                'payment_terms',
                'is_active'
            ]);
        });
    }
};