<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_debt_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('supplier_id')->constrained()->onDelete('cascade');
            $table->foreignId('purchase_invoice_id')->constrained()->onDelete('cascade');
            $table->date('schedule_date')->comment('تاريخ الاستحقاق المجدول');
            $table->decimal('scheduled_amount', 15, 2)->comment('المبلغ المجدول');
            $table->enum('status', ['scheduled', 'reminded', 'overdue', 'paid', 'cancelled'])->default('scheduled');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->datetime('reminder_sent_at')->nullable()->comment('تاريخ إرسال التذكير');
            $table->date('payment_deadline')->nullable()->comment('الموعد النهائي للدفع');
            $table->decimal('penalty_amount', 15, 2)->default(0)->comment('مبلغ الغرامة');
            $table->boolean('is_overdue')->default(false)->comment('متأخر');
            $table->timestamps();
            
            // فهارس للأداء
            $table->index(['supplier_id', 'schedule_date'], 'sds_supplier_date_idx');
            $table->index(['purchase_invoice_id'], 'sds_invoice_idx');
            $table->index(['status', 'schedule_date'], 'sds_status_date_idx');
            $table->index(['is_overdue'], 'sds_overdue_idx');
            $table->index(['schedule_date'], 'sds_schedule_date_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_debt_schedules');
    }
};