<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->enum('tax_calculation_method', ['exclusive', 'inclusive'])
                  ->default('exclusive')
                  ->after('is_control_account')
                  ->comment('طريقة حساب الضريبة - exclusive: غير شامل الضريبة، inclusive: شامل الضريبة');
            
            $table->boolean('applies_tax')->default(true)->after('tax_calculation_method')
                  ->comment('تطبيق الضريبة على هذا الحساب');
            
            $table->decimal('default_tax_rate', 5, 2)->nullable()->after('applies_tax')
                  ->comment('معدل الضريبة الافتراضي للحساب');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->dropColumn(['tax_calculation_method', 'applies_tax', 'default_tax_rate']);
        });
    }
};