<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            // تحديث enum لإضافة الحالة الجديدة
            $table->enum('status', [
                'draft', 
                'sent', 
                'cleared', 
                'reported', 
                'rejected', 
                'not_found_in_zatca'
            ])->default('draft')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            // إرجاع enum للحالة الأصلية
            $table->enum('status', [
                'draft', 
                'sent', 
                'cleared', 
                'reported', 
                'rejected'
            ])->default('draft')->change();
        });
    }
};