<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cost_centers', function (Blueprint $table) {
            $table->string('type')->nullable()->after('name_en')->comment('نوع مركز التكلفة');
            $table->string('manager_name')->nullable()->after('manager_id')->comment('اسم المدير المسؤول');
            $table->string('phone', 20)->nullable()->after('manager_name')->comment('رقم الهاتف');
            $table->string('budget_period')->default('monthly')->after('budget_amount')->comment('فترة الميزانية');
            $table->decimal('actual_amount', 15, 2)->default(0)->after('budget_period')->comment('المبلغ الفعلي المنفق');
            $table->integer('variance_threshold')->default(10)->after('actual_amount')->comment('حد التنبيه للانحراف');
            $table->boolean('allow_budget_exceeded')->default(false)->after('variance_threshold')->comment('السماح بتجاوز الميزانية');
            $table->boolean('requires_approval')->default(false)->after('allow_budget_exceeded')->comment('يتطلب موافقة للمصروفات');
            $table->boolean('track_performance')->default(true)->after('requires_approval')->comment('تتبع الأداء');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cost_centers', function (Blueprint $table) {
            $table->dropColumn([
                'type',
                'manager_name',
                'phone',
                'budget_period',
                'actual_amount',
                'variance_threshold',
                'allow_budget_exceeded',
                'requires_approval',
                'track_performance'
            ]);
        });
    }
};