<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_payment_allocations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('payment_voucher_id')->constrained('payment_vouchers')->onDelete('cascade');
            $table->foreignId('purchase_invoice_id')->constrained('purchase_invoices')->onDelete('cascade');
            $table->decimal('allocated_amount', 15, 2)->comment('المبلغ المخصص من الدفعة لهذه الفاتورة');
            $table->text('notes')->nullable()->comment('ملاحظات التخصيص');
            $table->timestamps();
            
            // فهارس
            $table->index(['payment_voucher_id'], 'spa_payment_idx');
            $table->index(['purchase_invoice_id'], 'spa_invoice_idx');
            $table->index(['payment_voucher_id', 'purchase_invoice_id'], 'spa_payment_invoice_idx');
            
            // قيود
            $table->unique(['payment_voucher_id', 'purchase_invoice_id'], 'spa_unique_payment_invoice');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_payment_allocations');
    }
};