<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->string('payment_number', 50)->unique()->comment('رقم الدفعة');
            $table->enum('type', ['received', 'paid', 'transfer', 'adjustment'])->comment('نوع الدفعة');
            $table->date('payment_date')->comment('تاريخ الدفعة');
            $table->foreignId('party_id')->nullable()->constrained('parties')->comment('الطرف (عميل/مورد)');
            $table->foreignId('invoice_id')->nullable()->constrained('accounting_invoices')->comment('الفاتورة');
            $table->foreignId('branch_id')->nullable()->constrained('branches')->comment('الفرع');
            $table->foreignId('cost_center_id')->nullable()->constrained('cost_centers')->comment('مركز التكلفة');
            $table->foreignId('currency_id')->constrained('currencies')->comment('العملة');
            $table->decimal('exchange_rate', 15, 6)->default(1)->comment('سعر الصرف');
            $table->decimal('amount', 15, 4)->comment('المبلغ');
            $table->decimal('amount_in_base_currency', 15, 4)->comment('المبلغ بالعملة الأساسية');
            $table->enum('payment_method', ['cash', 'bank_transfer', 'check', 'credit_card', 'debit_card', 'online', 'other'])->comment('طريقة الدفع');
            $table->string('payment_reference', 100)->nullable()->comment('مرجع الدفعة');
            $table->string('check_number', 50)->nullable()->comment('رقم الشيك');
            $table->date('check_date')->nullable()->comment('تاريخ الشيك');
            $table->string('bank_name', 255)->nullable()->comment('اسم البنك');
            $table->foreignId('bank_account_id')->nullable()->constrained('bank_accounts')->comment('الحساب البنكي');
            $table->string('transaction_id', 100)->nullable()->comment('رقم المعاملة');
            $table->enum('status', ['pending', 'cleared', 'bounced', 'cancelled'])->default('pending')->comment('الحالة');
            $table->date('cleared_date')->nullable()->comment('تاريخ المقاصة');
            $table->text('description')->nullable()->comment('الوصف');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->foreignId('journal_entry_id')->nullable()->constrained('journal_entries')->comment('القيد المحاسبي');
            $table->string('attachment_path', 500)->nullable()->comment('مسار المرفق');
            $table->json('allocation_details')->nullable()->comment('تفاصيل التوزيع');
            $table->decimal('bank_charges', 15, 4)->default(0)->comment('رسوم البنك');
            $table->decimal('exchange_gain_loss', 15, 4)->default(0)->comment('أرباح/خسائر الصرف');
            $table->boolean('is_advance')->default(false)->comment('دفعة مقدمة');
            $table->boolean('auto_allocate')->default(true)->comment('توزيع تلقائي');
            $table->timestamp('cleared_at')->nullable()->comment('وقت المقاصة');
            $table->timestamp('bounced_at')->nullable()->comment('وقت الارتداد');
            $table->timestamp('cancelled_at')->nullable()->comment('وقت الإلغاء');
            $table->foreignId('created_by')->nullable()->constrained('users')->comment('المنشئ');
            $table->foreignId('updated_by')->nullable()->constrained('users')->comment('المحدث');
            $table->foreignId('cleared_by')->nullable()->constrained('users')->comment('مقاص بواسطة');
            $table->foreignId('cancelled_by')->nullable()->constrained('users')->comment('ملغي بواسطة');
            $table->timestamps();
            $table->softDeletes();

            // الفهارس
            $table->index(['type', 'status']);
            $table->index(['party_id', 'payment_date']);
            $table->index(['invoice_id', 'status']);
            $table->index(['payment_method', 'status']);
            $table->index(['bank_account_id', 'payment_date']);
            $table->index(['branch_id', 'payment_date']);
            $table->index(['cost_center_id', 'payment_date']);
            $table->index('payment_number');
            $table->index('payment_date');
            $table->index('cleared_date');
            $table->index(['is_advance', 'status']);
            $table->index('amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};