<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accounting_invoices', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_number', 50)->unique()->comment('رقم الفاتورة');
            $table->enum('type', ['sales', 'purchase', 'return_sales', 'return_purchase', 'credit_note', 'debit_note'])->comment('نوع الفاتورة');
            $table->date('invoice_date')->comment('تاريخ الفاتورة');
            $table->date('due_date')->nullable()->comment('تاريخ الاستحقاق');
            $table->foreignId('party_id')->constrained('parties')->comment('الطرف (عميل/مورد)');
            $table->foreignId('branch_id')->nullable()->constrained('branches')->comment('الفرع');
            $table->foreignId('cost_center_id')->nullable()->constrained('cost_centers')->comment('مركز التكلفة');
            $table->foreignId('currency_id')->constrained('currencies')->comment('العملة');
            $table->decimal('exchange_rate', 15, 6)->default(1)->comment('سعر الصرف');
            $table->decimal('subtotal', 15, 4)->comment('المجموع الفرعي');
            $table->decimal('discount_amount', 15, 4)->default(0)->comment('مبلغ الخصم');
            $table->decimal('discount_percentage', 5, 2)->default(0)->comment('نسبة الخصم');
            $table->decimal('tax_amount', 15, 4)->default(0)->comment('مبلغ الضريبة');
            $table->decimal('total_amount', 15, 4)->comment('المبلغ الإجمالي');
            $table->decimal('paid_amount', 15, 4)->default(0)->comment('المبلغ المدفوع');
            $table->decimal('remaining_amount', 15, 4)->comment('المبلغ المتبقي');
            $table->enum('payment_status', ['unpaid', 'partially_paid', 'paid', 'overdue'])->default('unpaid')->comment('حالة الدفع');
            $table->enum('status', ['draft', 'sent', 'confirmed', 'cancelled', 'refunded'])->default('draft')->comment('الحالة');
            $table->string('reference', 100)->nullable()->comment('المرجع');
            $table->text('description')->nullable()->comment('الوصف');
            $table->text('terms_conditions')->nullable()->comment('الشروط والأحكام');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->json('items')->comment('البنود');
            $table->json('tax_details')->nullable()->comment('تفاصيل الضرائب');
            $table->json('payment_details')->nullable()->comment('تفاصيل الدفع');
            $table->foreignId('journal_entry_id')->nullable()->constrained('journal_entries')->comment('القيد المحاسبي');
            $table->foreignId('related_invoice_id')->nullable()->constrained('accounting_invoices')->comment('الفاتورة المرتبطة');
            $table->string('attachment_path', 500)->nullable()->comment('مسار المرفق');
            $table->boolean('is_recurring')->default(false)->comment('متكررة');
            $table->string('recurring_frequency', 20)->nullable()->comment('تكرار التكرار');
            $table->date('next_recurring_date')->nullable()->comment('تاريخ التكرار التالي');
            $table->boolean('auto_send')->default(false)->comment('إرسال تلقائي');
            $table->timestamp('sent_at')->nullable()->comment('تاريخ الإرسال');
            $table->timestamp('confirmed_at')->nullable()->comment('تاريخ التأكيد');
            $table->timestamp('cancelled_at')->nullable()->comment('تاريخ الإلغاء');
            $table->foreignId('created_by')->nullable()->constrained('users')->comment('المنشئ');
            $table->foreignId('updated_by')->nullable()->constrained('users')->comment('المحدث');
            $table->foreignId('sent_by')->nullable()->constrained('users')->comment('مرسل بواسطة');
            $table->foreignId('confirmed_by')->nullable()->constrained('users')->comment('مؤكد بواسطة');
            $table->foreignId('cancelled_by')->nullable()->constrained('users')->comment('ملغي بواسطة');
            $table->timestamps();
            $table->softDeletes();

            // الفهارس
            $table->index(['type', 'status']);
            $table->index(['party_id', 'status']);
            $table->index(['payment_status', 'due_date']);
            $table->index(['invoice_date', 'type']);
            $table->index(['branch_id', 'invoice_date']);
            $table->index(['cost_center_id', 'invoice_date']);
            $table->index('invoice_number');
            $table->index('due_date');
            $table->index(['is_recurring', 'next_recurring_date']);
            $table->index('remaining_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accounting_invoices');
    }
};