<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parties', function (Blueprint $table) {
            $table->id();
            $table->string('code', 50)->unique()->comment('كود الطرف');
            $table->string('name', 255)->comment('اسم الطرف');
            $table->string('name_en', 255)->nullable()->comment('الاسم بالإنجليزية');
            $table->enum('type', ['customer', 'supplier', 'both', 'employee', 'partner', 'other'])->comment('نوع الطرف');
            $table->enum('entity_type', ['individual', 'company', 'government', 'non_profit'])->default('company')->comment('نوع الكيان');
            $table->string('commercial_registration', 100)->nullable()->comment('السجل التجاري');
            $table->string('tax_number', 100)->nullable()->comment('الرقم الضريبي');
            $table->string('national_id', 100)->nullable()->comment('الهوية الوطنية');
            $table->string('email', 255)->nullable()->comment('البريد الإلكتروني');
            $table->string('phone', 20)->nullable()->comment('الهاتف');
            $table->string('mobile', 20)->nullable()->comment('الجوال');
            $table->string('fax', 20)->nullable()->comment('الفاكس');
            $table->string('website', 255)->nullable()->comment('الموقع الإلكتروني');
            $table->text('address')->nullable()->comment('العنوان');
            $table->string('city', 100)->nullable()->comment('المدينة');
            $table->string('state', 100)->nullable()->comment('المنطقة/الولاية');
            $table->string('postal_code', 20)->nullable()->comment('الرمز البريدي');
            $table->string('country', 100)->nullable()->comment('البلد');
            $table->string('contact_person', 255)->nullable()->comment('الشخص المسؤول');
            $table->string('contact_title', 100)->nullable()->comment('المسمى الوظيفي');
            $table->string('contact_phone', 20)->nullable()->comment('هاتف المسؤول');
            $table->string('contact_email', 255)->nullable()->comment('بريد المسؤول');
            $table->decimal('credit_limit', 15, 4)->nullable()->comment('حد الائتمان');
            $table->integer('credit_days')->nullable()->comment('أيام الائتمان');
            $table->decimal('opening_balance', 15, 4)->default(0)->comment('الرصيد الافتتاحي');
            $table->enum('opening_balance_type', ['debit', 'credit'])->nullable()->comment('نوع الرصيد الافتتاحي');
            $table->decimal('current_balance', 15, 4)->default(0)->comment('الرصيد الحالي');
            $table->date('last_transaction_date')->nullable()->comment('آخر معاملة');
            $table->foreignId('currency_id')->nullable()->constrained('currencies')->comment('العملة');
            $table->foreignId('payment_terms_id')->nullable()->comment('شروط الدفع');
            $table->string('payment_method', 50)->nullable()->comment('طريقة الدفع المفضلة');
            $table->string('bank_name', 255)->nullable()->comment('اسم البنك');
            $table->string('bank_account', 100)->nullable()->comment('رقم الحساب البنكي');
            $table->string('iban', 100)->nullable()->comment('رقم الآيبان');
            $table->string('swift_code', 20)->nullable()->comment('رمز السويفت');
            $table->decimal('discount_percentage', 5, 2)->nullable()->comment('نسبة الخصم');
            $table->foreignId('tax_id')->nullable()->constrained('taxes')->comment('الضريبة الافتراضية');
            $table->enum('risk_level', ['low', 'medium', 'high'])->default('medium')->comment('مستوى المخاطر');
            $table->enum('status', ['active', 'inactive', 'blocked', 'under_review'])->default('active')->comment('الحالة');
            $table->date('established_date')->nullable()->comment('تاريخ التأسيس');
            $table->string('industry', 100)->nullable()->comment('القطاع');
            $table->integer('employees_count')->nullable()->comment('عدد الموظفين');
            $table->decimal('annual_revenue', 15, 4)->nullable()->comment('الإيرادات السنوية');
            $table->json('documents')->nullable()->comment('المستندات');
            $table->json('contacts')->nullable()->comment('جهات الاتصال الإضافية');
            $table->json('custom_fields')->nullable()->comment('حقول مخصصة');
            $table->json('tags')->nullable()->comment('العلامات');
            $table->boolean('send_statements')->default(false)->comment('إرسال كشوف الحساب');
            $table->boolean('send_reminders')->default(false)->comment('إرسال التذكيرات');
            $table->string('statement_frequency', 20)->nullable()->comment('تكرار الكشوف');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->foreignId('created_by')->nullable()->constrained('users')->comment('المنشئ');
            $table->foreignId('updated_by')->nullable()->constrained('users')->comment('المحدث');
            $table->timestamps();
            $table->softDeletes();

            // الفهارس
            $table->index(['type', 'status']);
            $table->index(['entity_type', 'status']);
            $table->index(['tax_number', 'status']);
            $table->index(['commercial_registration', 'status']);
            $table->index(['city', 'country']);
            $table->index('code');
            $table->index('last_transaction_date');
            $table->index(['risk_level', 'status']);
            $table->index('current_balance');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parties');
    }
};