<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('depreciation_entries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('fixed_asset_id')->constrained('fixed_assets')->onDelete('cascade')->comment('الأصل الثابت');
            $table->foreignId('journal_entry_id')->nullable()->constrained('journal_entries')->onDelete('cascade')->comment('القيد المحاسبي');
            $table->string('period', 20)->comment('الفترة (YYYY-MM)');
            $table->date('depreciation_date')->comment('تاريخ الإهلاك');
            $table->decimal('depreciation_amount', 15, 4)->comment('مبلغ الإهلاك');
            $table->decimal('accumulated_depreciation_before', 15, 4)->comment('مجمع الإهلاك قبل');
            $table->decimal('accumulated_depreciation_after', 15, 4)->comment('مجمع الإهلاك بعد');
            $table->decimal('book_value_before', 15, 4)->comment('القيمة الدفترية قبل');
            $table->decimal('book_value_after', 15, 4)->comment('القيمة الدفترية بعد');
            $table->enum('calculation_method', ['straight_line', 'declining_balance', 'sum_of_years', 'units_of_production'])->comment('طريقة الحساب');
            $table->decimal('calculation_rate', 8, 4)->nullable()->comment('معدل الحساب');
            $table->json('calculation_details')->nullable()->comment('تفاصيل الحساب');
            $table->enum('status', ['draft', 'posted', 'reversed'])->default('draft')->comment('الحالة');
            $table->boolean('is_automatic')->default(true)->comment('تلقائي');
            $table->boolean('is_adjustment')->default(false)->comment('تسوية');
            $table->text('adjustment_reason')->nullable()->comment('سبب التسوية');
            $table->foreignId('reversed_by_id')->nullable()->constrained('depreciation_entries')->comment('عكس بواسطة');
            $table->timestamp('posted_at')->nullable()->comment('تاريخ الترحيل');
            $table->timestamp('reversed_at')->nullable()->comment('تاريخ العكس');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->foreignId('created_by')->nullable()->constrained('users')->comment('المنشئ');
            $table->foreignId('updated_by')->nullable()->constrained('users')->comment('المحدث');
            $table->timestamps();
            $table->softDeletes();

            // الفهارس
            $table->index(['fixed_asset_id', 'period']);
            $table->index(['status', 'depreciation_date']);
            $table->index(['is_automatic', 'status']);
            $table->index('period');
            $table->index('depreciation_date');
            $table->index('posted_at');

            // فهرس مركب لمنع التكرار
            $table->unique(['fixed_asset_id', 'period'], 'unique_asset_period');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('depreciation_entries');
    }
};