<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fixed_assets', function (Blueprint $table) {
            $table->id();
            $table->string('asset_number', 50)->unique()->comment('رقم الأصل');
            $table->string('name', 255)->comment('اسم الأصل');
            $table->string('name_en', 255)->nullable()->comment('الاسم بالإنجليزية');
            $table->text('description')->nullable()->comment('وصف الأصل');
            $table->enum('category', ['building', 'machinery', 'equipment', 'vehicle', 'furniture', 'computer', 'software', 'land', 'other'])->comment('فئة الأصل');
            $table->string('subcategory', 100)->nullable()->comment('الفئة الفرعية');
            $table->string('brand', 100)->nullable()->comment('العلامة التجارية');
            $table->string('model', 100)->nullable()->comment('الموديل');
            $table->string('serial_number', 100)->nullable()->comment('الرقم التسلسلي');
            $table->string('barcode', 100)->nullable()->comment('الرمز الشريطي');
            $table->date('purchase_date')->comment('تاريخ الشراء');
            $table->decimal('purchase_cost', 15, 4)->comment('تكلفة الشراء');
            $table->decimal('installation_cost', 15, 4)->default(0)->comment('تكلفة التركيب');
            $table->decimal('total_cost', 15, 4)->comment('التكلفة الإجمالية');
            $table->decimal('salvage_value', 15, 4)->default(0)->comment('القيمة التخريدية');
            $table->decimal('depreciable_amount', 15, 4)->comment('المبلغ القابل للإهلاك');
            $table->integer('useful_life_years')->comment('العمر الإنتاجي بالسنوات');
            $table->integer('useful_life_months')->comment('العمر الإنتاجي بالشهور');
            $table->enum('depreciation_method', ['straight_line', 'declining_balance', 'sum_of_years', 'units_of_production'])->default('straight_line')->comment('طريقة الإهلاك');
            $table->decimal('depreciation_rate', 8, 4)->nullable()->comment('معدل الإهلاك');
            $table->date('depreciation_start_date')->comment('تاريخ بداية الإهلاك');
            $table->decimal('accumulated_depreciation', 15, 4)->default(0)->comment('مجمع الإهلاك');
            $table->decimal('book_value', 15, 4)->comment('القيمة الدفترية');
            $table->decimal('market_value', 15, 4)->nullable()->comment('القيمة السوقية');
            $table->date('last_valuation_date')->nullable()->comment('تاريخ آخر تقييم');
            $table->string('supplier', 255)->nullable()->comment('المورد');
            $table->string('purchase_invoice', 100)->nullable()->comment('فاتورة الشراء');
            $table->string('warranty_period', 50)->nullable()->comment('فترة الضمان');
            $table->date('warranty_expiry')->nullable()->comment('انتهاء الضمان');
            $table->string('insurance_policy', 100)->nullable()->comment('بوليصة التأمين');
            $table->date('insurance_expiry')->nullable()->comment('انتهاء التأمين');
            $table->decimal('insurance_value', 15, 4)->nullable()->comment('قيمة التأمين');
            $table->foreignId('branch_id')->nullable()->constrained('branches')->comment('الفرع');
            $table->foreignId('cost_center_id')->nullable()->constrained('cost_centers')->comment('مركز التكلفة');
            $table->string('location', 255)->nullable()->comment('الموقع');
            $table->string('responsible_person', 255)->nullable()->comment('الشخص المسؤول');
            $table->string('department', 100)->nullable()->comment('القسم');
            $table->enum('condition', ['excellent', 'good', 'fair', 'poor', 'damaged'])->default('good')->comment('الحالة');
            $table->enum('status', ['active', 'inactive', 'disposed', 'under_maintenance', 'lost', 'stolen'])->default('active')->comment('الحالة');
            $table->date('disposal_date')->nullable()->comment('تاريخ الاستبعاد');
            $table->decimal('disposal_amount', 15, 4)->nullable()->comment('مبلغ الاستبعاد');
            $table->string('disposal_method', 100)->nullable()->comment('طريقة الاستبعاد');
            $table->text('disposal_reason')->nullable()->comment('سبب الاستبعاد');
            $table->json('maintenance_history')->nullable()->comment('تاريخ الصيانة');
            $table->date('next_maintenance_date')->nullable()->comment('تاريخ الصيانة القادمة');
            $table->json('attachments')->nullable()->comment('المرفقات');
            $table->json('custom_fields')->nullable()->comment('حقول مخصصة');
            $table->boolean('is_depreciable')->default(true)->comment('قابل للإهلاك');
            $table->boolean('generate_depreciation')->default(true)->comment('إنشاء قيود إهلاك');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->foreignId('created_by')->nullable()->constrained('users')->comment('المنشئ');
            $table->foreignId('updated_by')->nullable()->constrained('users')->comment('المحدث');
            $table->timestamps();
            $table->softDeletes();

            // الفهارس
            $table->index(['status', 'category']);
            $table->index(['branch_id', 'status']);
            $table->index(['cost_center_id', 'status']);
            $table->index('purchase_date');
            $table->index('depreciation_start_date');
            $table->index('next_maintenance_date');
            $table->index('warranty_expiry');
            $table->index('insurance_expiry');
            $table->index('asset_number');
            $table->index(['is_depreciable', 'generate_depreciation']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fixed_assets');
    }
};