<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('branches', function (Blueprint $table) {
            $table->id();
            $table->string('code', 20)->unique()->comment('كود الفرع');
            $table->string('name', 255)->comment('اسم الفرع');
            $table->string('name_en', 255)->nullable()->comment('الاسم بالإنجليزية');
            $table->text('description')->nullable()->comment('وصف الفرع');
            $table->enum('type', ['main', 'branch', 'warehouse', 'office', 'factory', 'other'])->default('branch')->comment('نوع الفرع');
            $table->foreignId('parent_id')->nullable()->constrained('branches')->comment('الفرع الأب');
            $table->string('manager_name', 255)->nullable()->comment('اسم المدير');
            $table->string('phone', 20)->nullable()->comment('الهاتف');
            $table->string('email', 255)->nullable()->comment('البريد الإلكتروني');
            $table->string('fax', 20)->nullable()->comment('الفاكس');
            $table->string('website', 255)->nullable()->comment('الموقع الإلكتروني');
            $table->text('address')->nullable()->comment('العنوان');
            $table->string('city', 100)->nullable()->comment('المدينة');
            $table->string('state', 100)->nullable()->comment('المنطقة/الولاية');
            $table->string('postal_code', 20)->nullable()->comment('الرمز البريدي');
            $table->string('country', 100)->nullable()->comment('البلد');
            $table->decimal('latitude', 10, 8)->nullable()->comment('خط العرض');
            $table->decimal('longitude', 11, 8)->nullable()->comment('خط الطول');
            $table->string('tax_registration', 100)->nullable()->comment('رقم التسجيل الضريبي');
            $table->string('commercial_registration', 100)->nullable()->comment('رقم السجل التجاري');
            $table->string('license_number', 100)->nullable()->comment('رقم الرخصة');
            $table->date('established_date')->nullable()->comment('تاريخ التأسيس');
            $table->decimal('capital', 15, 4)->nullable()->comment('رأس المال');
            $table->foreignId('currency_id')->nullable()->constrained('currencies')->comment('العملة الافتراضية');
            $table->string('timezone', 50)->nullable()->comment('المنطقة الزمنية');
            $table->string('language', 10)->default('ar')->comment('اللغة الافتراضية');
            $table->json('working_hours')->nullable()->comment('ساعات العمل');
            $table->json('contact_persons')->nullable()->comment('الأشخاص المسؤولين');
            $table->json('bank_accounts')->nullable()->comment('الحسابات البنكية');
            $table->json('settings')->nullable()->comment('إعدادات الفرع');
            $table->boolean('is_active')->default(true)->comment('نشط');
            $table->boolean('is_headquarters')->default(false)->comment('المقر الرئيسي');
            $table->integer('sort_order')->default(0)->comment('ترتيب العرض');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->foreignId('created_by')->nullable()->constrained('users')->comment('المنشئ');
            $table->foreignId('updated_by')->nullable()->constrained('users')->comment('المحدث');
            $table->timestamps();
            $table->softDeletes();

            // الفهارس
            $table->index(['is_active', 'type']);
            $table->index(['parent_id', 'is_active']);
            $table->index('is_headquarters');
            $table->index(['city', 'country']);
            $table->index('code');
            $table->index('sort_order');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('branches');
    }
};