<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->id();
            $table->string('code', 3)->unique()->comment('كود العملة ISO');
            $table->string('name', 100)->comment('اسم العملة');
            $table->string('name_en', 100)->comment('الاسم بالإنجليزية');
            $table->string('symbol', 10)->comment('رمز العملة');
            $table->string('symbol_position', 10)->default('before')->comment('موضع الرمز');
            $table->integer('decimal_places')->default(2)->comment('عدد الخانات العشرية');
            $table->string('decimal_separator', 5)->default('.')->comment('فاصل الأرقام العشرية');
            $table->string('thousands_separator', 5)->default(',')->comment('فاصل الآلاف');
            $table->decimal('exchange_rate', 15, 6)->default(1)->comment('سعر الصرف مقابل العملة الأساسية');
            $table->boolean('is_base_currency')->default(false)->comment('العملة الأساسية');
            $table->boolean('auto_update_rate')->default(false)->comment('تحديث السعر تلقائياً');
            $table->string('rate_source', 100)->nullable()->comment('مصدر سعر الصرف');
            $table->timestamp('last_rate_update')->nullable()->comment('آخر تحديث للسعر');
            $table->json('historical_rates')->nullable()->comment('الأسعار التاريخية');
            $table->boolean('is_active')->default(true)->comment('نشط');
            $table->integer('sort_order')->default(0)->comment('ترتيب العرض');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->foreignId('created_by')->nullable()->constrained('users')->comment('المنشئ');
            $table->foreignId('updated_by')->nullable()->constrained('users')->comment('المحدث');
            $table->timestamps();
            $table->softDeletes();

            // الفهارس
            $table->index(['is_active', 'sort_order']);
            $table->index('is_base_currency');
            $table->index('code');
            $table->index('last_rate_update');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currencies');
    }
};