<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('taxes', function (Blueprint $table) {
            $table->id();
            $table->string('code', 20)->unique()->comment('كود الضريبة');
            $table->string('name', 255)->comment('اسم الضريبة');
            $table->string('name_en', 255)->nullable()->comment('الاسم بالإنجليزية');
            $table->text('description')->nullable()->comment('وصف الضريبة');
            $table->enum('type', ['percentage', 'fixed'])->default('percentage')->comment('نوع الضريبة');
            $table->decimal('rate', 8, 4)->comment('معدل الضريبة');
            $table->decimal('minimum_amount', 15, 4)->nullable()->comment('أقل مبلغ للضريبة');
            $table->decimal('maximum_amount', 15, 4)->nullable()->comment('أعلى مبلغ للضريبة');
            $table->enum('calculation_method', ['exclusive', 'inclusive'])->default('exclusive')->comment('طريقة الحساب');
            $table->boolean('is_compound')->default(false)->comment('ضريبة مركبة');
            $table->json('compound_taxes')->nullable()->comment('الضرائب المركبة');
            $table->enum('applies_to', ['sales', 'purchases', 'both'])->default('both')->comment('تطبق على');
            $table->date('effective_from')->comment('تاريخ السريان');
            $table->date('effective_to')->nullable()->comment('تاريخ الانتهاء');
            $table->string('authority', 255)->nullable()->comment('الجهة الضريبية');
            $table->string('registration_number', 100)->nullable()->comment('رقم التسجيل الضريبي');
            $table->json('settings')->nullable()->comment('إعدادات إضافية');
            $table->boolean('is_active')->default(true)->comment('نشط');
            $table->boolean('is_default')->default(false)->comment('افتراضي');
            $table->integer('sort_order')->default(0)->comment('ترتيب العرض');
            $table->text('notes')->nullable()->comment('ملاحظات');
            $table->foreignId('created_by')->nullable()->constrained('users')->comment('المنشئ');
            $table->foreignId('updated_by')->nullable()->constrained('users')->comment('المحدث');
            $table->timestamps();
            $table->softDeletes();

            // الفهارس
            $table->index(['is_active', 'effective_from', 'effective_to']);
            $table->index(['type', 'applies_to']);
            $table->index(['is_default', 'is_active']);
            $table->index('sort_order');
            $table->index('effective_from');
            $table->index('code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('taxes');
    }
};