<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('saved_reports', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255); // اسم التقرير
            $table->string('report_type', 50); // نوع التقرير: trial_balance, balance_sheet, etc.
            $table->text('description')->nullable(); // وصف التقرير
            $table->json('parameters'); // معاملات التقرير (التواريخ، الفلاتر، إلخ)
            $table->json('filters')->nullable(); // الفلاتر المطبقة
            $table->enum('format', ['excel', 'pdf', 'csv', 'html'])->default('excel'); // تنسيق التصدير
            $table->string('file_path')->nullable(); // مسار الملف المحفوظ
            $table->integer('file_size')->nullable(); // حجم الملف بالبايت
            $table->boolean('is_scheduled')->default(false); // مجدول تلقائياً
            $table->string('schedule_frequency')->nullable(); // تكرار الجدولة: daily, weekly, monthly
            $table->json('schedule_config')->nullable(); // إعدادات الجدولة
            $table->timestamp('last_generated_at')->nullable(); // آخر توليد
            $table->timestamp('next_generation_at')->nullable(); // التوليد التالي
            $table->boolean('is_public')->default(false); // متاح للعامة
            $table->boolean('is_active')->default(true); // نشط
            $table->json('recipients')->nullable(); // المستلمون (للتقارير المجدولة)
            $table->unsignedBigInteger('created_by'); // منشئ التقرير
            $table->unsignedBigInteger('updated_by')->nullable(); // آخر محدث
            $table->timestamps();

            // الفهارس والقيود
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            
            $table->index('report_type');
            $table->index('is_scheduled');
            $table->index('is_active');
            $table->index(['created_by', 'is_active']);
            $table->index('next_generation_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('saved_reports');
    }
};