<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accounting_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key', 100)->unique(); // مفتاح الإعداد
            $table->text('value')->nullable(); // قيمة الإعداد
            $table->string('group', 50)->default('general'); // مجموعة الإعداد
            $table->string('type', 20)->default('text'); // نوع البيانات: text, number, boolean, json, etc.
            $table->string('label', 255); // تسمية الإعداد
            $table->text('description')->nullable(); // وصف الإعداد
            $table->text('validation_rules')->nullable(); // قواعد التحقق
            $table->json('options')->nullable(); // خيارات الإعداد (للقوائم المنسدلة)
            $table->string('default_value')->nullable(); // القيمة الافتراضية
            $table->boolean('is_public')->default(false); // متاح للعامة
            $table->boolean('is_editable')->default(true); // قابل للتعديل
            $table->boolean('requires_restart')->default(false); // يتطلب إعادة تشغيل
            $table->integer('sort_order')->default(0); // ترتيب العرض
            $table->timestamps();

            $table->index('group');
            $table->index(['group', 'sort_order']);
            $table->index('is_public');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accounting_settings');
    }
};