<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_balances', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('account_id'); // الحساب
            $table->unsignedBigInteger('fiscal_year_id'); // السنة المالية
            $table->unsignedBigInteger('cost_center_id')->nullable(); // مركز التكلفة (اختياري)
            $table->date('balance_date'); // تاريخ الرصيد
            $table->enum('balance_type', ['opening', 'closing', 'period_end', 'adjustment']); // نوع الرصيد
            $table->decimal('debit_balance', 15, 2)->default(0); // الرصيد المدين
            $table->decimal('credit_balance', 15, 2)->default(0); // الرصيد الدائن
            $table->decimal('net_balance', 15, 2)->default(0); // الرصيد الصافي
            $table->decimal('period_debits', 15, 2)->default(0); // إجمالي المدين للفترة
            $table->decimal('period_credits', 15, 2)->default(0); // إجمالي الدائن للفترة
            $table->integer('transaction_count')->default(0); // عدد المعاملات
            $table->boolean('is_calculated')->default(false); // محسوب تلقائياً
            $table->boolean('is_verified')->default(false); // تم التحقق منه
            $table->unsignedBigInteger('verified_by')->nullable(); // من قام بالتحقق
            $table->timestamp('verified_at')->nullable(); // تاريخ التحقق
            $table->text('notes')->nullable(); // ملاحظات
            $table->json('breakdown')->nullable(); // تفصيل الرصيد
            $table->timestamps();

            // الفهارس والقيود
            $table->foreign('account_id')->references('id')->on('accounts')->onDelete('cascade');
            $table->foreign('fiscal_year_id')->references('id')->on('fiscal_years')->onDelete('cascade');
            $table->foreign('cost_center_id')->references('id')->on('cost_centers')->onDelete('cascade');
            $table->foreign('verified_by')->references('id')->on('users')->onDelete('set null');
            
            // فهرس مركب لضمان عدم تكرار الرصيد لنفس الحساب والفترة
            $table->unique(['account_id', 'fiscal_year_id', 'balance_date', 'balance_type', 'cost_center_id'], 'unique_account_balance');
            
            $table->index(['account_id', 'balance_date']);
            $table->index(['fiscal_year_id', 'balance_type']);
            $table->index('balance_date');
            $table->index('is_calculated');
            $table->index('is_verified');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('account_balances');
    }
};