<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('budgets', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255); // اسم الميزانية
            $table->string('code', 50)->unique(); // رمز الميزانية
            $table->unsignedBigInteger('fiscal_year_id'); // السنة المالية
            $table->unsignedBigInteger('cost_center_id')->nullable(); // مركز التكلفة
            $table->unsignedBigInteger('account_id')->nullable(); // الحساب (اختياري)
            $table->enum('period_type', ['monthly', 'quarterly', 'annual'])->default('annual'); // نوع الفترة
            $table->date('start_date'); // تاريخ البداية
            $table->date('end_date'); // تاريخ النهاية
            $table->decimal('budgeted_amount', 15, 2); // المبلغ المخطط
            $table->decimal('actual_amount', 15, 2)->default(0); // المبلغ الفعلي
            $table->decimal('committed_amount', 15, 2)->default(0); // المبلغ المرتبط
            $table->decimal('variance_amount', 15, 2)->default(0); // مبلغ الانحراف
            $table->decimal('variance_percentage', 8, 2)->default(0); // نسبة الانحراف
            $table->enum('status', ['draft', 'approved', 'active', 'closed'])->default('draft'); // الحالة
            $table->text('description')->nullable(); // الوصف
            $table->json('monthly_breakdown')->nullable(); // التفصيل الشهري
            $table->boolean('is_active')->default(true); // نشط
            $table->boolean('auto_calculate')->default(true); // حساب تلقائي
            $table->decimal('warning_threshold', 5, 2)->default(80); // حد التحذير بالنسبة المئوية
            $table->decimal('critical_threshold', 5, 2)->default(95); // الحد الحرج بالنسبة المئوية
            $table->unsignedBigInteger('created_by'); // منشئ الميزانية
            $table->unsignedBigInteger('approved_by')->nullable(); // معتمد الميزانية
            $table->timestamp('approved_at')->nullable(); // تاريخ الاعتماد
            $table->timestamp('last_calculated_at')->nullable(); // آخر حساب
            $table->timestamps();

            // الفهارس والقيود
            $table->foreign('fiscal_year_id')->references('id')->on('fiscal_years')->onDelete('cascade');
            $table->foreign('cost_center_id')->references('id')->on('cost_centers')->onDelete('cascade');
            $table->foreign('account_id')->references('id')->on('accounts')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
            
            $table->index(['fiscal_year_id', 'cost_center_id']);
            $table->index(['start_date', 'end_date']);
            $table->index('status');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('budgets');
    }
};