<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('audit_logs', function (Blueprint $table) {
            $table->id();
            $table->string('event'); // نوع الحدث: created, updated, deleted, approved, etc.
            $table->string('auditable_type'); // نوع النموذج: App\Models\Account
            $table->unsignedBigInteger('auditable_id'); // معرف السجل
            $table->unsignedBigInteger('user_id')->nullable(); // المستخدم الذي قام بالعملية
            $table->string('user_type')->nullable(); // نوع المستخدم
            $table->json('old_values')->nullable(); // القيم القديمة
            $table->json('new_values')->nullable(); // القيم الجديدة
            $table->string('url')->nullable(); // الرابط
            $table->string('ip_address', 45)->nullable(); // عنوان IP
            $table->string('user_agent')->nullable(); // معلومات المتصفح
            $table->text('description')->nullable(); // وصف العملية
            $table->json('tags')->nullable(); // تسميات إضافية
            $table->timestamp('created_at');

            $table->index(['auditable_type', 'auditable_id']);
            $table->index('user_id');
            $table->index('event');
            $table->index('created_at');
            
            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('audit_logs');
    }
};