<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fiscal_years', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100); // مثل: السنة المالية 2025
            $table->date('start_date'); // بداية السنة المالية
            $table->date('end_date'); // نهاية السنة المالية
            $table->boolean('is_current')->default(false); // السنة المالية الحالية
            $table->boolean('is_closed')->default(false); // مغلقة أم لا
            $table->date('closed_at')->nullable(); // تاريخ الإغلاق
            $table->unsignedBigInteger('closed_by')->nullable(); // من قام بالإغلاق
            $table->decimal('opening_balance_total', 15, 2)->default(0); // إجمالي الرصيد الافتتاحي
            $table->decimal('closing_balance_total', 15, 2)->default(0); // إجمالي الرصيد الختامي
            $table->text('notes')->nullable(); // ملاحظات
            $table->timestamps();

            $table->foreign('closed_by')->references('id')->on('users')->onDelete('set null');
            $table->index(['start_date', 'end_date']);
            $table->index('is_current');
            $table->index('is_closed');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fiscal_years');
    }
};