<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bank_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('transaction_number')->unique();
            $table->date('transaction_date');
            $table->unsignedBigInteger('bank_account_id');
            $table->enum('type', ['deposit', 'withdrawal', 'transfer', 'fee', 'interest']);
            $table->decimal('amount', 15, 2);
            $table->string('reference')->nullable();
            $table->text('description');
            $table->string('payee_payer')->nullable();
            $table->string('check_number')->nullable();
            $table->enum('status', ['pending', 'cleared', 'cancelled'])->default('pending');
            $table->date('cleared_date')->nullable();
            $table->unsignedBigInteger('journal_entry_id')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->json('attachments')->nullable();
            $table->timestamps();

            $table->foreign('bank_account_id')->references('id')->on('bank_accounts');
            $table->foreign('journal_entry_id')->references('id')->on('journal_entries');
            $table->foreign('created_by')->references('id')->on('users');
            $table->index(['transaction_date', 'status']);
            $table->index('bank_account_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bank_transactions');
    }
};