<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cash_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('transaction_number')->unique();
            $table->date('transaction_date');
            $table->unsignedBigInteger('cash_account_id');
            $table->enum('type', ['receipt', 'payment']);
            $table->decimal('amount', 15, 2);
            $table->string('reference')->nullable();
            $table->text('description');
            $table->unsignedBigInteger('received_from')->nullable();
            $table->unsignedBigInteger('paid_to')->nullable();
            $table->string('payment_method')->nullable();
            $table->string('check_number')->nullable();
            $table->date('check_date')->nullable();
            $table->string('bank_name')->nullable();
            $table->unsignedBigInteger('journal_entry_id')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->json('attachments')->nullable();
            $table->timestamps();

            $table->foreign('cash_account_id')->references('id')->on('accounts');
            $table->foreign('journal_entry_id')->references('id')->on('journal_entries');
            $table->foreign('created_by')->references('id')->on('users');
            $table->index(['transaction_date', 'type']);
            $table->index('cash_account_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cash_transactions');
    }
};