<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('folders', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // اسم المجلد
            $table->string('slug')->unique(); // معرف المجلد في الURL
            $table->text('description')->nullable(); // وصف المجلد
            $table->string('color', 7)->default('#3498db'); // لون المجلد
            $table->string('icon')->default('fas fa-folder'); // أيقونة المجلد
            $table->foreignId('parent_id')->nullable()->constrained('folders')->onDelete('cascade'); // المجلد الأب
            $table->string('path'); // المسار الكامل للمجلد
            $table->integer('level')->default(0); // مستوى المجلد في الهيكل
            $table->boolean('is_public')->default(false); // مجلد عام أم خاص
            $table->string('access_level')->default('private'); // مستوى الوصول
            $table->json('permissions')->nullable(); // صلاحيات المجلد
            $table->foreignId('created_by')->constrained('users')->onDelete('restrict'); // منشئ المجلد
            $table->integer('files_count')->default(0); // عدد الملفات في المجلد
            $table->integer('subfolders_count')->default(0); // عدد المجلدات الفرعية
            $table->bigInteger('total_size')->default(0); // الحجم الإجمالي بالبايت
            $table->boolean('is_system')->default(false); // مجلد نظام
            $table->integer('sort_order')->default(0); // ترتيب العرض
            $table->timestamps();
            
            // فهارس للبحث السريع
            $table->index(['parent_id', 'is_public']);
            $table->index(['created_by', 'created_at']);
            $table->index(['level', 'sort_order']);
            $table->index('path');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('folders');
    }
};
