<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('files', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // اسم الملف الأصلي
            $table->string('filename'); // اسم الملف المحفوظ
            $table->string('path'); // مسار الملف
            $table->string('extension'); // امتداد الملف
            $table->string('mime_type'); // نوع الملف
            $table->bigInteger('size'); // حجم الملف بالبايت
            $table->text('description')->nullable(); // وصف الملف
            $table->string('category')->default('general'); // تصنيف الملف
            $table->json('metadata')->nullable(); // معلومات إضافية
            $table->boolean('is_public')->default(false); // ملف عام أم خاص
            $table->string('access_level')->default('private'); // مستوى الوصول
            $table->foreignId('uploaded_by')->constrained('users')->onDelete('restrict'); // المستخدم الذي رفع الملف
            $table->integer('download_count')->default(0); // عدد مرات التحميل
            $table->timestamp('last_downloaded_at')->nullable(); // آخر مرة تم تحميل الملف
            $table->json('tags')->nullable(); // علامات للبحث
            $table->string('hash', 64)->unique(); // hash للملف للتأكد من عدم التكرار
            $table->boolean('is_archived')->default(false); // هل الملف مؤرشف
            $table->timestamp('expires_at')->nullable(); // تاريخ انتهاء الصلاحية
            $table->timestamps();
            
            // فهارس للبحث السريع
            $table->index(['category', 'is_archived']);
            $table->index(['uploaded_by', 'created_at']);
            $table->index(['mime_type', 'is_public']);
            $table->index('hash');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('files');
    }
};
