<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_adjustments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('adjustment_number')->unique(); // رقم التسوية
            $table->date('adjustment_date'); // تاريخ التسوية
            $table->enum('type', ['increase', 'decrease', 'recount']); // نوع التسوية
            $table->string('reason'); // السبب
            $table->enum('status', ['pending', 'approved', 'cancelled'])->default('pending'); // الحالة
            $table->text('notes')->nullable(); // ملاحظات
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_adjustments');
    }
};