<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_movements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->enum('type', [
                'purchase', 'sale', 'adjustment_in', 'adjustment_out',
                'return_in', 'return_out', 'transfer_in', 'transfer_out'
            ]); // نوع الحركة
            $table->integer('quantity'); // الكمية (موجبة للإدخال، سالبة للإخراج)
            $table->decimal('unit_cost', 10, 2)->nullable(); // تكلفة الوحدة
            $table->decimal('total_cost', 12, 2)->nullable(); // التكلفة الإجمالية
            $table->string('reference_type')->nullable(); // نوع المرجع
            $table->unsignedBigInteger('reference_id')->nullable(); // معرف المرجع
            $table->text('notes')->nullable(); // ملاحظات
            $table->timestamp('movement_date'); // تاريخ الحركة
            $table->timestamps();

            $table->index(['product_id', 'movement_date']);
            $table->index(['reference_type', 'reference_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_movements');
    }
};