<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('supplier_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('po_number')->unique(); // رقم أمر الشراء
            $table->date('order_date'); // تاريخ الأمر
            $table->date('expected_delivery_date')->nullable(); // تاريخ التسليم المتوقع
            $table->enum('status', [
                'draft', 'pending', 'approved', 'sent', 
                'partially_received', 'received', 'cancelled'
            ])->default('draft'); // الحالة
            $table->decimal('subtotal', 12, 2)->default(0); // المجموع الفرعي
            $table->decimal('tax_amount', 12, 2)->default(0); // مبلغ الضريبة
            $table->decimal('total_amount', 12, 2)->default(0); // المجموع الكلي
            $table->text('notes')->nullable(); // ملاحظات
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_orders');
    }
};