<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suppliers', function (Blueprint $table) {
            $table->id();
            $table->string('code', 50)->unique()->nullable(); // كود المورد
            $table->string('name'); // اسم المورد
            $table->string('name_en')->nullable(); // الاسم بالإنجليزية
            $table->string('contact_person')->nullable(); // الشخص المسؤول
            $table->string('email')->nullable(); // البريد الإلكتروني
            $table->string('phone')->nullable(); // الهاتف
            $table->string('mobile')->nullable(); // الجوال
            $table->text('address')->nullable(); // العنوان
            $table->string('city')->nullable(); // المدينة
            $table->string('country')->default('Saudi Arabia'); // البلد
            $table->string('postal_code')->nullable(); // الرمز البريدي
            $table->string('tax_number')->nullable(); // الرقم الضريبي
            $table->string('commercial_registration')->nullable(); // السجل التجاري
            $table->string('payment_terms')->nullable(); // شروط الدفع
            $table->integer('payment_terms_days')->default(30); // أيام الدفع
            $table->enum('payment_method', ['cash', 'credit', 'bank_transfer', 'check'])->default('credit'); // طريقة الدفع
            $table->string('currency', 3)->default('SAR'); // العملة
            $table->decimal('credit_limit', 12, 2)->default(0); // حد الائتمان
            $table->decimal('current_balance', 12, 2)->default(0); // الرصيد الحالي
            $table->text('notes')->nullable(); // ملاحظات
            $table->boolean('is_active')->default(true); // نشط
            $table->timestamps();
            
            // الفهارس
            $table->index(['is_active']);
            $table->index(['current_balance']);
            $table->index(['name']);
            $table->index(['email']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suppliers');
    }
};