<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            // طريقة السداد
            $table->enum('payment_method', ['cash', 'bank_transfer', 'check', 'credit_card', 'installment'])->nullable()->after('total_amount');
            
            // المبلغ المدفوع والمتبقي
            $table->decimal('paid_amount', 15, 2)->default(0)->after('payment_method');
            $table->decimal('remaining_amount', 15, 2)->default(0)->after('paid_amount');
            
            // حالة السداد
            $table->enum('payment_status', ['unpaid', 'partial', 'paid', 'overdue'])->default('unpaid')->after('remaining_amount');
            
            // تاريخ السداد
            $table->datetime('payment_date')->nullable()->after('payment_status');
            
            // إشعارات الدائن والمدين
            $table->boolean('creditor_notification_sent')->default(false)->after('payment_date');
            $table->datetime('creditor_notification_sent_at')->nullable()->after('creditor_notification_sent');
            $table->boolean('debtor_notification_sent')->default(false)->after('creditor_notification_sent_at');
            $table->datetime('debtor_notification_sent_at')->nullable()->after('debtor_notification_sent');
            
            // ملاحظات السداد
            $table->text('payment_notes')->nullable()->after('debtor_notification_sent_at');
            
            // حقول إدارة الديون
            $table->boolean('is_high_risk')->default(false)->after('payment_notes');
            $table->datetime('risk_marked_at')->nullable()->after('is_high_risk');
            $table->datetime('last_reminder_sent_at')->nullable()->after('risk_marked_at');
            
            // فهرس لحالة السداد
            $table->index(['payment_status', 'due_date']);
            $table->index(['is_high_risk', 'due_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropIndex(['payment_status', 'due_date']);
            $table->dropIndex(['is_high_risk', 'due_date']);
            $table->dropColumn([
                'payment_method',
                'paid_amount',
                'remaining_amount',
                'payment_status',
                'payment_date',
                'creditor_notification_sent',
                'creditor_notification_sent_at',
                'debtor_notification_sent',
                'debtor_notification_sent_at',
                'payment_notes',
                'is_high_risk',
                'risk_marked_at',
                'last_reminder_sent_at'
            ]);
        });
    }
};