<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('zatca_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            
            // نوع الربط
            $table->enum('connection_type', ['clearance', 'reporting'])->default('clearance');
            
            // البيئة
            $table->enum('environment', ['sandbox', 'production'])->default('sandbox');
            
            // بيانات جهاز التوقيع الإلكتروني (CSID)
            $table->text('certificate')->nullable(); // الشهادة الرقمية
            $table->text('private_key')->nullable(); // المفتاح الخاص
            $table->text('public_key')->nullable(); // المفتاح العام
            $table->string('certificate_serial')->nullable(); // الرقم التسلسلي للشهادة
            $table->datetime('certificate_expires_at')->nullable(); // تاريخ انتهاء الشهادة
            
            // بيانات الاتصال
            $table->string('client_id')->nullable(); // معرف العميل
            $table->text('client_secret')->nullable(); // سر العميل
            $table->string('username')->nullable(); // اسم المستخدم
            $table->text('password')->nullable(); // كلمة المرور
            $table->text('access_token')->nullable(); // رمز الوصول
            $table->datetime('token_expires_at')->nullable(); // تاريخ انتهاء الرمز
            
            // إعدادات الفواتير
            $table->integer('invoice_counter')->default(0); // عداد الفواتير
            $table->string('previous_invoice_hash')->nullable(); // Hash آخر فاتورة
            
            // حالة الاتصال
            $table->boolean('is_active')->default(false); // نشط/غير نشط
            $table->datetime('last_connection_test')->nullable(); // آخر اختبار اتصال
            $table->enum('connection_status', ['connected', 'disconnected', 'error'])->default('disconnected');
            $table->text('last_error')->nullable(); // آخر خطأ
            
            // سجل العمليات
            $table->json('operation_log')->nullable(); // سجل العمليات
            
            $table->timestamps();
            
            // فهرس فريد لكل شركة
            $table->unique('company_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('zatca_settings');
    }
};
