<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_id')->nullable()->constrained()->onDelete('set null');
            
            // بيانات المنتج/الخدمة
            $table->string('name'); // اسم المنتج
            $table->string('name_en')->nullable(); // الاسم بالإنجليزية
            $table->text('description')->nullable(); // الوصف
            $table->string('sku')->nullable(); // رمز المنتج
            
            // الكمية والوحدة
            $table->decimal('quantity', 10, 3); // الكمية
            $table->string('unit')->default('piece'); // الوحدة
            
            // الأسعار
            $table->decimal('unit_price', 10, 2); // سعر الوحدة بدون ضريبة
            $table->decimal('line_total', 10, 2); // إجمالي السطر بدون ضريبة
            $table->decimal('discount_amount', 10, 2)->default(0); // الخصم
            $table->decimal('discount_percentage', 5, 2)->default(0); // نسبة الخصم
            
            // الضريبة
            $table->decimal('tax_rate', 5, 2); // معدل الضريبة
            $table->decimal('tax_amount', 10, 2); // مبلغ الضريبة
            $table->decimal('total_with_tax', 10, 2); // الإجمالي شامل الضريبة
            
            // تصنيفات ZATCA
            $table->string('zatca_category_code')->nullable(); // رمز التصنيف
            $table->boolean('is_taxable')->default(true); // خاضع للضريبة
            
            $table->timestamps();
            
            // فهارس
            $table->index(['invoice_id', 'product_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_items');
    }
};
