<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_number')->unique(); // رقم الفاتورة
            $table->enum('type', ['standard', 'simplified']); // نوع الفاتورة
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->foreignId('customer_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // المستخدم المنشئ
            
            // تواريخ مهمة
            $table->datetime('issue_date'); // تاريخ الإصدار
            $table->datetime('due_date')->nullable(); // تاريخ الاستحقاق
            $table->datetime('supply_date')->nullable(); // تاريخ التوريد
            
            // المبالغ
            $table->decimal('subtotal', 15, 2)->default(0); // المجموع الفرعي
            $table->decimal('tax_amount', 15, 2)->default(0); // مبلغ الضريبة
            $table->decimal('discount_amount', 15, 2)->default(0); // الخصم
            $table->decimal('total_amount', 15, 2)->default(0); // المبلغ الإجمالي
            $table->string('currency', 3)->default('SAR'); // العملة
            
            // معلومات ZATCA
            $table->string('uuid')->unique(); // UUID للفاتورة
            $table->string('invoice_hash')->nullable(); // Hash الفاتورة
            $table->string('previous_invoice_hash')->nullable(); // Hash الفاتورة السابقة
            $table->integer('invoice_counter'); // عداد الفاتورة
            $table->text('qr_code')->nullable(); // QR Code
            $table->string('irn')->nullable(); // رقم التعريف من ZATCA
            
            // حالة الفاتورة
            $table->enum('status', ['draft', 'sent', 'cleared', 'reported', 'rejected'])->default('draft');
            $table->text('zatca_response')->nullable(); // استجابة ZATCA
            $table->datetime('sent_to_zatca_at')->nullable(); // تاريخ الإرسال لـ ZATCA
            
            // ملفات
            $table->string('xml_file_path')->nullable(); // مسار ملف XML
            $table->string('pdf_file_path')->nullable(); // مسار ملف PDF
            
            $table->text('notes')->nullable(); // ملاحظات
            $table->timestamps();
            
            // فهارس
            $table->index(['company_id', 'issue_date']);
            $table->index(['status', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
