<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // اسم المنتج
            $table->string('name_en')->nullable(); // الاسم بالإنجليزية
            $table->text('description')->nullable(); // الوصف
            $table->string('sku')->unique(); // رمز المنتج
            $table->string('barcode')->nullable(); // الباركود
            $table->enum('type', ['product', 'service'])->default('product'); // نوع: منتج أو خدمة
            
            // الأسعار
            $table->decimal('price', 10, 2); // السعر بدون ضريبة
            $table->decimal('price_with_tax', 10, 2); // السعر شامل الضريبة
            $table->decimal('tax_rate', 5, 2)->default(15.00); // معدل الضريبة
            
            // المخزون
            $table->integer('stock_quantity')->default(0); // الكمية المتوفرة
            $table->integer('min_stock')->default(0); // الحد الأدنى للمخزون
            $table->string('unit')->default('piece'); // الوحدة (قطعة، كيلو، متر...)
            
            // تصنيفات ZATCA
            $table->string('zatca_category_code')->nullable(); // رمز التصنيف
            $table->boolean('is_taxable')->default(true); // خاضع للضريبة
            
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
